/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import ratpack.exec.Blocking;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.file.internal.FileReadingPublisher;
import ratpack.file.internal.FileWritingSubscriber;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.bytebuf.ByteBufStreams;

public class FileIo {
    private FileIo() {
    }

    public static Promise<AsynchronousFileChannel> open(Path file, OpenOption ... options) {
        return FileIo.open(file, (Set<? extends OpenOption>)ImmutableSet.copyOf((Object[])options), new FileAttribute[0]);
    }

    public static Promise<AsynchronousFileChannel> open(Path file, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        return Blocking.get(() -> AsynchronousFileChannel.open(file, options, (ExecutorService)Execution.current().getEventLoop(), attrs));
    }

    public static Promise<Long> write(Publisher<? extends ByteBuf> publisher, Promise<? extends AsynchronousFileChannel> file) {
        return FileIo.write(publisher, 0L, file);
    }

    public static Promise<Long> write(Publisher<? extends ByteBuf> publisher, long position, Promise<? extends AsynchronousFileChannel> file) {
        return file.flatMap(fileChannel -> Promise.async(down -> publisher.subscribe((Subscriber)new FileWritingSubscriber((AsynchronousFileChannel)fileChannel, position, (Downstream<? super Long>)down))).close(Blocking.op(() -> {
            fileChannel.force(false);
            fileChannel.close();
        })));
    }

    public static Operation write(ByteBuf bytes, Promise<? extends AsynchronousFileChannel> file) {
        return FileIo.write(bytes, 0L, file);
    }

    public static Operation write(final ByteBuf bytes, long position, Promise<? extends AsynchronousFileChannel> file) {
        return file.flatMap(channel -> Promise.async(down -> channel.write(bytes.nioBuffer(), position, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment) {
                bytes.readerIndex(bytes.readerIndex() + result);
                down.success(null);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                down.error(exc);
            }
        })).close(() -> ((ByteBuf)bytes).release()).close(Blocking.op(() -> {
            channel.force(false);
            channel.close();
        }))).operation();
    }

    public static TransformablePublisher<ByteBuf> readStream(Promise<? extends AsynchronousFileChannel> file, ByteBufAllocator allocator, int bufferSize, long start, long stop) {
        return new FileReadingPublisher(file, allocator, bufferSize, start, stop);
    }

    public static TransformablePublisher<ByteBuf> readStream(Promise<? extends AsynchronousFileChannel> file, ByteBufAllocator allocator, int bufferSize) {
        return new FileReadingPublisher(file, allocator, bufferSize, 0L, 0L);
    }

    public static Promise<CompositeByteBuf> read(Promise<? extends AsynchronousFileChannel> file, ByteBufAllocator allocator, int bufferSize, long start, long stop) {
        return ByteBufStreams.compose(FileIo.readStream(file, allocator, bufferSize, start, stop), (ByteBufAllocator)allocator);
    }

    public static Promise<CompositeByteBuf> read(Promise<? extends AsynchronousFileChannel> file, ByteBufAllocator allocator, int bufferSize) {
        return ByteBufStreams.compose(FileIo.readStream(file, allocator, bufferSize), (ByteBufAllocator)allocator);
    }
}

