/*
 * Decompiled with CFR 0.152.
 */
package ratpack.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import org.reactivestreams.Publisher;
import ratpack.api.Nullable;
import ratpack.func.Function;
import ratpack.http.ResponseChunks;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.jackson.JsonParseOpts;
import ratpack.jackson.JsonRender;
import ratpack.jackson.internal.DefaultJsonParseOpts;
import ratpack.jackson.internal.DefaultJsonRender;
import ratpack.parse.Parse;
import ratpack.registry.Registry;
import ratpack.stream.Streams;
import ratpack.stream.WriteStream;

public abstract class Jackson {
    private Jackson() {
    }

    public static JsonRender json(Object object) {
        return new DefaultJsonRender(object, null, null);
    }

    public static JsonRender json(Object object, @Nullable ObjectWriter objectWriter) {
        return new DefaultJsonRender(object, objectWriter);
    }

    public static JsonRender json(Object object, @Nullable Class<?> viewClass) {
        return new DefaultJsonRender(object, viewClass);
    }

    public static JsonRender json(Object object, @Nullable ObjectWriter objectWriter, @Nullable Class<?> viewClass) {
        return new DefaultJsonRender(object, objectWriter, viewClass);
    }

    public static Parse<JsonNode, JsonParseOpts> jsonNode() {
        return Jackson.jsonNode(null);
    }

    public static Parse<JsonNode, JsonParseOpts> jsonNode(@Nullable ObjectMapper objectMapper) {
        return Jackson.fromJson(JsonNode.class, objectMapper);
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(Class<T> type) {
        return Jackson.fromJson(type, null);
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(TypeToken<T> type) {
        return Jackson.fromJson(type, null);
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(Class<T> type, @Nullable ObjectMapper objectMapper) {
        return Parse.of(type, new DefaultJsonParseOpts(objectMapper));
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(TypeToken<T> type, @Nullable ObjectMapper objectMapper) {
        return Parse.of(type, new DefaultJsonParseOpts(objectMapper));
    }

    public static <T> ResponseChunks chunkedJsonList(Registry registry, Publisher<T> stream) {
        return Jackson.chunkedJsonList(Jackson.getObjectWriter(registry), stream);
    }

    public static ObjectWriter getObjectWriter(Registry registry) {
        return registry.maybeGet(ObjectWriter.class).orElseGet(() -> ((ObjectMapper)registry.get(ObjectMapper.class)).writer());
    }

    public static <T> ResponseChunks chunkedJsonList(ObjectWriter objectWriter, Publisher<T> stream) {
        return ResponseChunks.bufferChunks(HttpHeaderConstants.JSON, (Publisher<? extends ByteBuf>)Streams.streamMap(stream, (s, out) -> {
            final JsonGenerator generator = objectWriter.getFactory().createGenerator(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    out.item((Object)Unpooled.copiedBuffer((byte[])b, (int)off, (int)len));
                }
            });
            generator.writeStartArray();
            return new WriteStream<T>(){

                public void item(T item) {
                    try {
                        generator.writeObject(item);
                    }
                    catch (Exception e) {
                        s.cancel();
                        out.error((Throwable)e);
                    }
                }

                public void error(Throwable throwable) {
                    out.error(throwable);
                }

                public void complete() {
                    try {
                        generator.writeEndArray();
                        generator.close();
                        out.complete();
                    }
                    catch (IOException e) {
                        out.error((Throwable)e);
                    }
                }
            };
        }));
    }

    @Deprecated
    public static <T> Function<T, String> toJson(Registry registry) {
        return arg_0 -> ((ObjectWriter)Jackson.getObjectWriter(registry)).writeValueAsString(arg_0);
    }
}

