/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakDetector;
import java.io.FileOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.api.Nullable;
import ratpack.config.ConfigObject;
import ratpack.exec.Blocking;
import ratpack.exec.Downstream;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInitializer;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Promise;
import ratpack.exec.Throttle;
import ratpack.exec.internal.ExecThreadBinding;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.http.internal.ConnectionIdleTimeout;
import ratpack.impose.Impositions;
import ratpack.impose.UserRegistryImposition;
import ratpack.registry.Registry;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ReloadInformant;
import ratpack.server.ServerChannelOptions;
import ratpack.server.ServerConfig;
import ratpack.server.internal.HostUtil;
import ratpack.server.internal.IgnorableHttpContentCompressor;
import ratpack.server.internal.NettyHandlerAdapter;
import ratpack.server.internal.RatpackServerDefinition;
import ratpack.server.internal.ServerCapturer;
import ratpack.server.internal.ServerRegistry;
import ratpack.server.internal.Slf4jNoBindingDetector;
import ratpack.service.internal.DefaultEvent;
import ratpack.service.internal.ServicesGraph;
import ratpack.util.Exceptions;
import ratpack.util.Types;
import ratpack.util.internal.TransportDetector;

public class DefaultRatpackServer
implements RatpackServer {
    public static final TypeToken<ReloadInformant> RELOAD_INFORMANT_TYPE = Types.token(ReloadInformant.class);
    public static final AttributeKey<Throttle> CHANNEL_THROTTLE_KEY = AttributeKey.valueOf(DefaultRatpackServer.class, (String)"channelThrottle");
    public static final TypeToken<HandlerDecorator> HANDLER_DECORATOR_TYPE_TOKEN;
    public static final Logger LOGGER;
    protected final Action<? super RatpackServerSpec> definitionFactory;
    @Nullable
    private volatile RunningState runningState;
    private final ReloadingState reloadingState = new ReloadingState();
    private final Impositions impositions;
    @Nullable
    private Thread shutdownHookThread;

    public DefaultRatpackServer(Action<? super RatpackServerSpec> definitionFactory, Impositions impositions) throws Exception {
        this.definitionFactory = definitionFactory;
        this.impositions = impositions;
        ServerCapturer.capture(this);
    }

    @Override
    public synchronized void start() throws Exception {
        RunningState runningState;
        if (this.isRunning()) {
            return;
        }
        ApplicationState applicationState = new ApplicationState();
        LOGGER.info("Starting server...");
        applicationState.definitionBuild = this.buildUserDefinition();
        RatpackServerDefinition definition = applicationState.definitionBuild.definition;
        if (applicationState.definitionBuild.error != null) {
            if (definition.serverConfig.isDevelopment()) {
                LOGGER.warn("Exception raised getting server config (will use default config until reload):", applicationState.definitionBuild.error);
            } else {
                throw Exceptions.toException((Throwable)applicationState.definitionBuild.error);
            }
        }
        ServerConfig serverConfig = definition.serverConfig;
        boolean inheritedExecController = serverConfig.getInheritedExecController().isPresent();
        ExecController execController = serverConfig.getInheritedExecController().orElseGet(() -> ExecController.builder().numThreads(serverConfig.getThreads()).build());
        try {
            ChannelHandler channelHandler = (ChannelHandler)ExecThreadBinding.bindFor((boolean)true, (ExecController)execController, () -> DefaultRatpackServer.buildHandler(this, applicationState, this.impositions, this.reloadingState, execController, inheritedExecController, (Factory<DefinitionBuild>)((Factory)this::buildUserDefinition)));
            Channel channel = DefaultRatpackServer.buildChannel(serverConfig, channelHandler, execController);
            InetSocketAddress boundAddress = (InetSocketAddress)channel.localAddress();
            this.runningState = runningState = new RunningState(boundAddress, channel, execController, inheritedExecController, serverConfig.getNettySslContext() != null, applicationState);
        }
        catch (Throwable e) {
            execController.close();
            throw e;
        }
        this.postStart(runningState);
    }

    private void postStart(RunningState runningState) throws Exception {
        ServerConfig serverConfig = ((DefinitionBuild)Objects.requireNonNull(((ApplicationState)((RunningState)runningState).applicationState).definitionBuild)).definition.serverConfig;
        try {
            String startMessage = String.format("Ratpack started %sfor %s://%s:%s", serverConfig.isDevelopment() ? "(development) " : "", this.getScheme(), this.getBindHost(), this.getBindPort());
            if (serverConfig.getPortFile().isPresent()) {
                Path portFilePath = serverConfig.getPortFile().get();
                try (FileOutputStream fout = new FileOutputStream(portFilePath.toFile());){
                    fout.write(Integer.toString(this.getBindPort()).getBytes());
                }
            }
            if (Slf4jNoBindingDetector.isHasBinding()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(startMessage);
                }
            } else {
                System.out.println(startMessage);
            }
            if (serverConfig.isRegisterShutdownHook()) {
                this.shutdownHookThread = new Thread("ratpack-shutdown-thread"){

                    @Override
                    public void run() {
                        try {
                            DefaultRatpackServer.this.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
            }
        }
        catch (Throwable e) {
            this.stop();
            throw e;
        }
    }

    private DefinitionBuild buildUserDefinition() throws Exception {
        return (DefinitionBuild)this.impositions.imposeOver(() -> {
            try {
                return new DefinitionBuild(this.impositions, RatpackServerDefinition.build(this.definitionFactory), null);
            }
            catch (Exception e) {
                return new DefinitionBuild(this.impositions, RatpackServerDefinition.build((Action<? super RatpackServerSpec>)((Action)s -> s.handler((Function<? super Registry, ? extends Handler>)((Function)r -> ctx -> ctx.error(e))))), e);
            }
        });
    }

    private static ChannelHandler buildHandler(RatpackServer server, ApplicationState applicationState, Impositions impositions, ReloadingState reloadingState, ExecController execController, boolean inheritedExecController, Factory<DefinitionBuild> definitionBuilder) throws Exception {
        if (((DefinitionBuild)Objects.requireNonNull(((ApplicationState)applicationState).definitionBuild)).definition.serverConfig.isDevelopment()) {
            return new ReloadHandler(server, applicationState, reloadingState, impositions, execController, inheritedExecController, definitionBuilder);
        }
        return DefaultRatpackServer.buildAdapter(server, applicationState, reloadingState, impositions, execController, inheritedExecController);
    }

    private static Channel buildChannel(final ServerConfig serverConfig, final ChannelHandler handlerAdapter, ExecController execController) throws InterruptedException {
        final SslContext sslContext = serverConfig.getNettySslContext();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverConfig.getConnectTimeoutMillis().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, i);
            serverBootstrap.childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, i);
        });
        serverConfig.getMaxMessagesPerRead().ifPresent(i -> {
            FixedRecvByteBufAllocator allocator = new FixedRecvByteBufAllocator(i.intValue());
            serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)allocator);
            serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)allocator);
        });
        serverConfig.getReceiveBufferSize().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.SO_RCVBUF, i);
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, i);
        });
        serverConfig.getWriteSpinCount().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.WRITE_SPIN_COUNT, i);
            serverBootstrap.childOption(ChannelOption.WRITE_SPIN_COUNT, i);
        });
        serverConfig.getConnectQueueSize().ifPresent(i -> serverBootstrap.option(ChannelOption.SO_BACKLOG, i));
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)serverConfig.isTcpKeepAlive());
        ((ServerBootstrap)serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT);
        DefaultRatpackServer.applyServerChildOptions(serverConfig, serverBootstrap);
        return ((ServerBootstrap)serverBootstrap.group(execController.getEventLoopGroup()).channel(TransportDetector.getServerSocketChannelImpl())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                new ConnectionIdleTimeout(pipeline, serverConfig.getIdleTimeout());
                if (sslContext != null) {
                    SSLEngine sslEngine = sslContext.newEngine(ByteBufAllocator.DEFAULT);
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(serverConfig.getMaxInitialLineLength(), serverConfig.getMaxHeaderSize(), serverConfig.getMaxChunkSize(), false));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("deflater", (ChannelHandler)new IgnorableHttpContentCompressor());
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("adapter", handlerAdapter);
                ch.config().setAutoRead(false);
            }
        }).bind((SocketAddress)DefaultRatpackServer.buildSocketAddress(serverConfig)).sync().channel();
    }

    private static void applyServerChildOptions(ServerConfig serverConfig, final ServerBootstrap serverBootstrap) {
        for (ConfigObject configObject : serverConfig.getRequiredConfig()) {
            if (!ServerChannelOptions.class.isAssignableFrom(configObject.getType())) continue;
            ServerChannelOptions serverChannelOptions = (ServerChannelOptions)configObject.getObject();
            serverChannelOptions.setOptions(new ServerChannelOptions.OptionSetter(){

                @Override
                public <T> ServerChannelOptions.OptionSetter set(ChannelOption<T> option, T value) {
                    serverBootstrap.option(option, value);
                    return this;
                }
            });
            serverChannelOptions.setChildOptions(new ServerChannelOptions.OptionSetter(){

                @Override
                public <T> ServerChannelOptions.OptionSetter set(ChannelOption<T> option, T value) {
                    serverBootstrap.childOption(option, value);
                    return this;
                }
            });
        }
    }

    private static NettyHandlerAdapter buildAdapter(RatpackServer server, ApplicationState applicationState, ReloadingState reloadingState, Impositions impositions, ExecController execController, boolean inheritedExecController) throws Exception {
        LOGGER.info("Building registry...");
        applicationState.serverRegistry = DefaultRatpackServer.buildServerRegistry(((DefinitionBuild)Objects.requireNonNull(((ApplicationState)applicationState).definitionBuild)).definition.serverConfig, (Function<? super Registry, ? extends Registry>)applicationState.definitionBuild.userRegistryFactory, server, impositions, execController);
        if (!inheritedExecController) {
            execController.addInterceptors((Iterable)ImmutableList.copyOf((Iterable)applicationState.serverRegistry.getAll(ExecInterceptor.class)));
            execController.addInitializers((Iterable)ImmutableList.copyOf((Iterable)applicationState.serverRegistry.getAll(ExecInitializer.class)));
        }
        Handler ratpackHandler = DefaultRatpackServer.buildRatpackHandler(applicationState.serverRegistry, ((DefinitionBuild)((ApplicationState)applicationState).definitionBuild).definition.handler);
        ratpackHandler = DefaultRatpackServer.decorateHandler(ratpackHandler, applicationState.serverRegistry);
        applicationState.servicesGraph = new ServicesGraph(applicationState.serverRegistry);
        applicationState.servicesGraph.start(new DefaultEvent(applicationState.serverRegistry, reloadingState.reloading));
        return new NettyHandlerAdapter(applicationState.serverRegistry, ratpackHandler);
    }

    private static Registry buildServerRegistry(ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory, RatpackServer ratpackServer, Impositions impositions, ExecController execController) {
        return ServerRegistry.serverRegistry(ratpackServer, impositions, execController, serverConfig, userRegistryFactory);
    }

    private static Handler decorateHandler(Handler rootHandler, Registry serverRegistry) throws Exception {
        Iterable all = serverRegistry.getAll(HANDLER_DECORATOR_TYPE_TOKEN);
        for (HandlerDecorator handlerDecorator : all) {
            rootHandler = handlerDecorator.decorate(serverRegistry, rootHandler);
        }
        return rootHandler;
    }

    private static Handler buildRatpackHandler(Registry serverRegistry, Function<? super Registry, ? extends Handler> handlerFactory) throws Exception {
        return (Handler)handlerFactory.apply((Object)serverRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        RunningState runningState = this.runningState;
        if (runningState == null) {
            return;
        }
        this.runningState = null;
        try {
            if (this.shutdownHookThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.info("Stopping server...");
        try {
            if (runningState.channel != null) {
                runningState.channel.close().sync();
            }
            try {
                this.shutdownServices(runningState.applicationState, this.reloadingState);
            }
            finally {
                if (!runningState.inheritedExecController) {
                    runningState.execController.close();
                }
            }
            LOGGER.info("Server stopped.");
        }
        finally {
            runningState.stopLatch.countDown();
        }
    }

    @Override
    public boolean await(Duration timeout) throws InterruptedException {
        RunningState runningState = this.runningState;
        if (runningState == null) {
            return true;
        }
        return runningState.stopLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void shutdownServices(ApplicationState applicationState, ReloadingState reloadingState) throws Exception {
        if (applicationState.servicesGraph != null) {
            applicationState.servicesGraph.stop(new DefaultEvent(applicationState.serverRegistry, reloadingState.reloading));
        }
    }

    @Override
    public synchronized RatpackServer reload() throws Exception {
        this.reloadingState.reloading = true;
        boolean start = false;
        if (this.isRunning()) {
            start = true;
            this.stop();
        }
        if (start) {
            this.start();
        }
        this.reloadingState.reloading = false;
        return this;
    }

    @Override
    public Optional<Registry> getRegistry() {
        return Optional.ofNullable(this.runningState).map(r -> ((RunningState)r).applicationState).map(a -> ((ApplicationState)a).serverRegistry);
    }

    @Override
    public synchronized boolean isRunning() {
        return this.runningState != null;
    }

    @Override
    public synchronized String getScheme() {
        return Optional.ofNullable(this.runningState).map(r -> ((RunningState)r).useSsl ? "https" : "http").orElse(null);
    }

    @Override
    public synchronized int getBindPort() {
        return Optional.ofNullable(this.runningState).map(r -> ((RunningState)r).boundAddress.getPort()).orElse(-1);
    }

    @Override
    public synchronized String getBindHost() {
        return Optional.ofNullable(this.runningState).map(r -> HostUtil.determineHost(((RunningState)r).boundAddress)).orElse(null);
    }

    private static InetSocketAddress buildSocketAddress(ServerConfig serverConfig) {
        return serverConfig.getAddress() == null ? new InetSocketAddress(serverConfig.getPort()) : new InetSocketAddress(serverConfig.getAddress(), serverConfig.getPort());
    }

    static {
        if (System.getProperty("io.netty.leakDetectionLevel", null) == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        HANDLER_DECORATOR_TYPE_TOKEN = Types.token(HandlerDecorator.class);
        LOGGER = LoggerFactory.getLogger(RatpackServer.class);
    }

    @ChannelHandler.Sharable
    private static final class ReloadHandler
    extends ChannelInboundHandlerAdapter {
        private ServerConfig lastServerConfig;
        private final RatpackServer server;
        private final ApplicationState applicationState;
        private final ReloadingState reloadingState;
        private final Impositions impositions;
        private final ExecController execController;
        private final Throttle reloadThrottle = Throttle.ofSize((int)1);
        private final boolean inheritedExecController;
        private final Factory<DefinitionBuild> definitionBuilder;
        private ChannelInboundHandlerAdapter inner;

        public ReloadHandler(RatpackServer server, ApplicationState applicationState, ReloadingState reloadingState, Impositions impositions, ExecController execController, boolean inheritedExecController, Factory<DefinitionBuild> definitionBuilder) {
            this.server = server;
            this.applicationState = applicationState;
            this.reloadingState = reloadingState;
            this.impositions = impositions;
            this.execController = execController;
            this.inheritedExecController = inheritedExecController;
            this.definitionBuilder = definitionBuilder;
            this.lastServerConfig = ((DefinitionBuild)Objects.requireNonNull(((ApplicationState)applicationState).definitionBuild)).definition.serverConfig;
            try {
                this.inner = DefaultRatpackServer.buildAdapter(server, applicationState, reloadingState, impositions, execController, inheritedExecController);
            }
            catch (Exception e) {
                LOGGER.warn("An error occurred during startup. This will be ignored due to being in development mode.", (Throwable)e);
                this.inner = null;
                applicationState.serverRegistry = DefaultRatpackServer.buildServerRegistry(this.lastServerConfig, (Function<? super Registry, ? extends Registry>)r -> r, server, impositions, execController);
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.read();
            super.channelActive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Throttle requestThrottle;
            if (this.execController == null) {
                ReferenceCountUtil.release((Object)msg);
                ctx.fireChannelReadComplete();
                return;
            }
            if (msg instanceof HttpRequest) {
                requestThrottle = Throttle.ofSize((int)1);
                ctx.channel().attr(CHANNEL_THROTTLE_KEY).set((Object)requestThrottle);
            } else {
                requestThrottle = (Throttle)ctx.channel().attr(CHANNEL_THROTTLE_KEY).get();
            }
            this.execController.fork().eventLoop(ctx.channel().eventLoop()).start(e -> Promise.async(f -> {
                Optional reloadInformant;
                boolean rebuild = false;
                if (this.inner == null || Objects.requireNonNull(this.applicationState.definitionBuild).error != null) {
                    rebuild = true;
                } else if (msg instanceof HttpRequest && (reloadInformant = this.applicationState.serverRegistry.first(RELOAD_INFORMANT_TYPE, r -> r.shouldReload(this.applicationState.serverRegistry) ? r : null)).isPresent()) {
                    LOGGER.debug("reload requested by '" + reloadInformant.get() + "'");
                    rebuild = true;
                }
                if (rebuild) {
                    Blocking.get(() -> {
                        this.applicationState.definitionBuild = (DefinitionBuild)this.definitionBuilder.create();
                        this.lastServerConfig = ((DefinitionBuild)((ApplicationState)this.applicationState).definitionBuild).definition.serverConfig;
                        return DefaultRatpackServer.buildAdapter(this.server, this.applicationState, this.reloadingState, this.impositions, this.execController, this.inheritedExecController);
                    }).wiretap(r -> {
                        if (r.isSuccess()) {
                            this.inner = (ChannelInboundHandlerAdapter)r.getValue();
                        }
                    }).mapError(this::buildErrorRenderingAdapter).result(arg_0 -> ((Downstream)f).accept(arg_0));
                } else {
                    f.success((Object)this.inner);
                }
            }).wiretap(r -> {
                try {
                    ctx.pipeline().remove("inner");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ctx.pipeline().addLast("inner", (ChannelHandler)r.getValueOrThrow());
            }).throttled(this.reloadThrottle).throttled(requestThrottle).then(adapter -> ctx.fireChannelRead(msg)));
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            if (this.inner == null) {
                super.channelRegistered(ctx);
            } else {
                this.inner.channelRegistered(ctx);
            }
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            if (this.inner == null) {
                super.channelUnregistered(ctx);
            } else {
                this.inner.channelUnregistered(ctx);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.inner == null) {
                super.channelInactive(ctx);
            } else {
                this.inner.channelInactive(ctx);
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (this.inner == null) {
                super.channelReadComplete(ctx);
            } else {
                this.inner.channelReadComplete(ctx);
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (this.inner == null) {
                super.userEventTriggered(ctx, evt);
            } else {
                this.inner.userEventTriggered(ctx, evt);
            }
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            if (this.inner == null) {
                super.channelWritabilityChanged(ctx);
            } else {
                this.inner.channelWritabilityChanged(ctx);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.inner == null) {
                super.exceptionCaught(ctx, cause);
            } else {
                this.inner.exceptionCaught(ctx, cause);
            }
        }

        private NettyHandlerAdapter buildErrorRenderingAdapter(Throwable e) {
            try {
                return new NettyHandlerAdapter(this.applicationState.serverRegistry, context -> context.error(e));
            }
            catch (Exception e1) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
    }

    private static final class DefinitionBuild {
        private final RatpackServerDefinition definition;
        private final Throwable error;
        private final Function<? super Registry, ? extends Registry> userRegistryFactory;

        DefinitionBuild(Impositions impositions, RatpackServerDefinition definition, Throwable error) {
            this.definition = definition;
            this.error = error;
            this.userRegistryFactory = baseRegistry -> {
                Registry userRegistry = (Registry)definition.registry.apply(baseRegistry);
                for (UserRegistryImposition userRegistryImposition : impositions.getAll(UserRegistryImposition.class)) {
                    userRegistry = userRegistry.join(userRegistryImposition.build(userRegistry));
                }
                return userRegistry;
            };
        }
    }

    private static final class ReloadingState {
        private boolean reloading;

        private ReloadingState() {
        }
    }

    private static final class ApplicationState {
        @Nullable
        private DefinitionBuild definitionBuild;
        @Nullable
        private Registry serverRegistry;
        @Nullable
        private ServicesGraph servicesGraph;

        private ApplicationState() {
        }
    }

    private static final class RunningState {
        private final InetSocketAddress boundAddress;
        private final Channel channel;
        private final ExecController execController;
        private final boolean useSsl;
        private final ApplicationState applicationState;
        private final CountDownLatch stopLatch = new CountDownLatch(1);
        private final boolean inheritedExecController;

        RunningState(InetSocketAddress boundAddress, Channel channel, ExecController execController, boolean inheritedExecController, boolean useSsl, ApplicationState applicationState) {
            this.boundAddress = boundAddress;
            this.channel = channel;
            this.execController = execController;
            this.inheritedExecController = inheritedExecController;
            this.useSsl = useSsl;
            this.applicationState = applicationState;
        }
    }
}

