/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import ratpack.config.ConfigSource;
import ratpack.file.FileSystemBinding;
import ratpack.util.internal.Paths2;

public abstract class JacksonConfigSource
implements ConfigSource {
    private final ByteSource byteSource;

    public JacksonConfigSource(Path path) {
        this(Paths2.asByteSource((Path)path));
    }

    public JacksonConfigSource(URL url) {
        this(Resources.asByteSource((URL)url));
    }

    public JacksonConfigSource(ByteSource byteSource) {
        this.byteSource = byteSource;
    }

    @Override
    public ObjectNode loadConfigData(ObjectMapper objectMapper, FileSystemBinding fileSystemBinding) throws Exception {
        try (InputStream inputStream = this.byteSource.openStream();){
            ObjectNode objectNode;
            block12: {
                JsonParser parser = this.getFactory(objectMapper).createParser(inputStream);
                try {
                    objectNode = (ObjectNode)objectMapper.readTree(parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return objectNode;
        }
    }

    protected abstract JsonFactory getFactory(ObjectMapper var1);
}

