/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import ratpack.http.internal.RequestIdleTimeout;

public class ConnectionIdleTimeout
implements RequestIdleTimeout {
    private static final String HANDLER_NAME = "timeout";
    private final ChannelPipeline channelPipeline;
    private final Duration timeout;
    boolean handlerRegistered;

    public ConnectionIdleTimeout(ChannelPipeline channelPipeline, Duration timeout) {
        this.channelPipeline = channelPipeline;
        this.timeout = timeout;
        if (!timeout.isZero()) {
            this.init(timeout);
        }
    }

    @Override
    public void setRequestIdleTimeout(Duration idleTimeout) {
        if (idleTimeout.isNegative()) {
            throw new IllegalArgumentException("idleTimeout must not be negative");
        }
        if (this.handlerRegistered) {
            this.channelPipeline.remove(HANDLER_NAME);
        }
        if (idleTimeout.isZero()) {
            this.handlerRegistered = false;
        } else {
            this.init(idleTimeout);
        }
    }

    public void reset() {
        if (this.handlerRegistered) {
            this.channelPipeline.remove(HANDLER_NAME);
        }
        if (!this.timeout.isZero()) {
            this.init(this.timeout);
        }
    }

    private void init(Duration duration) {
        long millis = duration.toMillis();
        this.channelPipeline.addFirst(HANDLER_NAME, (ChannelHandler)new IdleStateHandler(millis, millis, 0L, TimeUnit.MILLISECONDS));
        this.handlerRegistered = true;
    }
}

