/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.func.Action;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DescribingHandler;
import ratpack.handling.internal.DescribingHandlers;
import ratpack.http.Response;
import ratpack.http.internal.ConnectionIdleTimeout;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.registry.Registry;
import ratpack.render.internal.DefaultRenderController;
import ratpack.server.ServerConfig;
import ratpack.server.internal.DefaultResponseTransmitter;
import ratpack.server.internal.RequestBody;
import ratpack.server.internal.ResponseTransmitter;

@ChannelHandler.Sharable
public class NettyHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHandlerAdapter.class);
    private final Handler[] handlers;
    private final DefaultContext.ApplicationConstants applicationConstants;
    private final Registry serverRegistry;
    private final boolean development;
    private final Clock clock;
    private final Duration idleTimeout;
    private final ServerConfig serverConfig;

    public NettyHandlerAdapter(Registry serverRegistry, Handler handler) {
        this.serverConfig = (ServerConfig)serverRegistry.get(ServerConfig.class);
        this.handlers = ChainHandler.unpack(handler);
        this.serverRegistry = serverRegistry;
        this.applicationConstants = new DefaultContext.ApplicationConstants(this.serverRegistry, new DefaultRenderController(), (ExecController)serverRegistry.get(ExecController.class), Handlers.notFound());
        this.development = this.serverConfig.isDevelopment();
        this.clock = (Clock)serverRegistry.get(Clock.class);
        this.idleTimeout = this.serverConfig.getIdleTimeout();
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        Attribute attr = ctx.channel().attr(ChannelState.KEY);
        if (attr.get() == null) {
            ChannelState state = new ChannelState(new ConnectionIdleTimeout(ctx.pipeline(), this.idleTimeout));
            attr.set((Object)state);
            ctx.channel().closeFuture().addListener(future -> {
                if (state.responseTransmitter != null) {
                    state.responseTransmitter.onConnectionClosed();
                }
                if (state.requestBody != null) {
                    state.requestBody.onClose();
                }
            });
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ChannelState state = NettyHandlerAdapter.state(ctx);
        if (state.messageQueue == null) {
            this.handleMessage(ctx, msg, state);
        } else {
            state.messageQueue.add(msg);
        }
    }

    private void handleMessage(ChannelHandlerContext ctx, Object msg, ChannelState state) throws Exception {
        if (msg instanceof HttpRequest) {
            this.handleRequest(ctx, (HttpRequest)msg, state);
        } else if (msg instanceof HttpContent) {
            NettyHandlerAdapter.handleContent(ctx, (HttpContent)msg, state);
        } else {
            this.handleOther(ctx, msg, state);
        }
    }

    private void handleRequest(ChannelHandlerContext ctx, HttpRequest request, ChannelState state) {
        state.requestedNextRequest = false;
        if (state.responseTransmitter == null) {
            this.newRequest(ctx, request, state);
        } else {
            state.messageQueue = new ArrayDeque<Object>();
            state.messageQueue.add(request);
        }
    }

    private static void handleContent(ChannelHandlerContext ctx, HttpContent httpContent, ChannelState state) {
        if (state.requestBody == null) {
            httpContent.release();
        } else {
            state.requestBody.add(httpContent.touch());
        }
        if (httpContent instanceof LastHttpContent) {
            state.requestedNextRequest = true;
            ctx.channel().read();
        }
    }

    private void handleOther(ChannelHandlerContext ctx, Object msg, ChannelState state) throws Exception {
        Action<Object> subscriber = state.rawSubscriber;
        if (subscriber == null) {
            super.channelRead(ctx, ReferenceCountUtil.touch((Object)msg));
        } else {
            subscriber.execute(ReferenceCountUtil.touch((Object)msg));
        }
    }

    private void newRequest(ChannelHandlerContext ctx, HttpRequest nettyRequest, ChannelState state) {
        if (!nettyRequest.decoderResult().isSuccess()) {
            LOGGER.debug("Failed to decode HTTP request.", nettyRequest.decoderResult().cause());
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        NettyHeadersBackedHeaders requestHeaders = new NettyHeadersBackedHeaders(nettyRequest.headers());
        long contentLength = HttpUtil.getContentLength((HttpMessage)nettyRequest, (long)-1L);
        String transferEncoding = requestHeaders.get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        boolean hasBody = contentLength > 0L || transferEncoding != null;
        state.requestBody = hasBody ? new RequestBody(contentLength, nettyRequest, ctx) : null;
        Channel channel = ctx.channel();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        DefaultRequest request = new DefaultRequest(this.clock.instant(), requestHeaders, nettyRequest.method(), nettyRequest.protocolVersion(), nettyRequest.uri(), remoteAddress, socketAddress, this.serverConfig, state.requestBody, state.idleTimeout, state.clientCert);
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders();
        NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)nettyHeaders);
        AtomicBoolean responseInitiated = new AtomicBoolean(false);
        state.responseTransmitter = new DefaultResponseTransmitter(responseInitiated, channel, this.clock, nettyRequest, request, (HttpHeaders)nettyHeaders, state.requestBody, () -> this.onResponseSent(ctx, state));
        DefaultContext.RequestConstants requestConstants = new DefaultContext.RequestConstants(this.applicationConstants, request, channel, state.responseTransmitter, (Action<Action<Object>>)((Action)rawChannelSubscriber -> {
            responseInitiated.set(true);
            state.rawSubscriber = rawChannelSubscriber;
        }));
        DefaultResponse response = new DefaultResponse(responseHeaders, ctx.alloc(), state.responseTransmitter, state.idleTimeout);
        requestConstants.response = response;
        DefaultContext.start(channel.eventLoop(), requestConstants, this.serverRegistry, this.handlers, (Action<? super Execution>)((Action)execution -> {
            if (!responseInitiated.get()) {
                this.unhandledRequest(ctx, (Execution)execution, requestConstants, request, response, state.responseTransmitter);
            }
        }));
    }

    private void onResponseSent(ChannelHandlerContext ctx, ChannelState state) {
        state.idleTimeout.reset();
        state.responseTransmitter = null;
        Queue<Object> queue = state.messageQueue;
        if (queue != null) {
            Object next;
            do {
                next = queue.poll();
                try {
                    this.handleMessage(ctx, next, NettyHandlerAdapter.state(ctx));
                }
                catch (Exception e) {
                    ctx.fireExceptionCaught((Throwable)e);
                    return;
                }
            } while (!(next instanceof LastHttpContent) && !queue.isEmpty());
            if (queue.isEmpty()) {
                state.messageQueue = null;
            }
        }
        if (!state.requestedNextRequest) {
            state.requestedNextRequest = true;
            ctx.channel().read();
        }
    }

    private void unhandledRequest(ChannelHandlerContext ctx, Execution execution, DefaultContext.RequestConstants requestConstants, DefaultRequest request, Response response, ResponseTransmitter responseTransmitter) {
        ByteBuf body;
        Handler lastHandler = requestConstants.handler;
        StringBuilder description = new StringBuilder();
        description.append("No response sent for ").append(request.getMethod().getName()).append(" request to ").append(request.getUri());
        if (lastHandler != null) {
            description.append(" (last handler: ");
            if (lastHandler instanceof DescribingHandler) {
                ((DescribingHandler)lastHandler).describeTo(description);
            } else {
                DescribingHandlers.describeTo(lastHandler, description);
            }
            description.append(")");
        }
        String message = description.toString();
        LOGGER.warn(message);
        response.getHeaders().clear();
        if (this.development) {
            CharBuffer charBuffer = CharBuffer.wrap(message);
            body = ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)charBuffer, (Charset)CharsetUtil.UTF_8);
            response.contentType(HttpHeaderConstants.PLAIN_TEXT_UTF8);
        } else {
            body = Unpooled.EMPTY_BUFFER;
        }
        response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, body.readableBytes());
        execution.getController().fork().eventLoop(execution.getEventLoop()).start(e -> responseTransmitter.transmit(HttpResponseStatus.INTERNAL_SERVER_ERROR, body));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Channel channel;
        if (!NettyHandlerAdapter.isIgnorableException(cause)) {
            LOGGER.error("", cause);
        }
        if ((channel = ctx.channel()).isActive()) {
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        } else {
            channel.close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        SSLEngine engine;
        ChannelState state = NettyHandlerAdapter.state(ctx);
        if (evt instanceof IdleStateEvent) {
            if (state.requestBody != null) {
                state.requestBody.onIdleTimeout();
            }
            ctx.close();
        }
        if (evt instanceof SslHandshakeCompletionEvent && ((SslHandshakeCompletionEvent)evt).isSuccess() && ((engine = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine()).getWantClientAuth() || engine.getNeedClientAuth())) {
            try {
                X509Certificate clientCert;
                state.clientCert = clientCert = engine.getSession().getPeerCertificateChain()[0];
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ChannelState state = NettyHandlerAdapter.state(ctx);
        ResponseTransmitter responseTransmitter = state.responseTransmitter;
        if (responseTransmitter != null) {
            responseTransmitter.onWritabilityChanged();
        }
        super.channelWritabilityChanged(ctx);
    }

    private static boolean isIgnorableException(Throwable throwable) {
        if (throwable instanceof ClosedChannelException) {
            return true;
        }
        if (throwable instanceof IOException) {
            String message = throwable.getMessage();
            if (message == null) {
                return false;
            }
            return (message = message.toLowerCase(Locale.ROOT)).endsWith("connection reset by peer") || message.contains("broken pipe");
        }
        return false;
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set(HttpHeaderConstants.CONTENT_TYPE, (Object)HttpHeaderConstants.PLAIN_TEXT_UTF8);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static ChannelState state(ChannelHandlerContext ctx) {
        return (ChannelState)ctx.channel().attr(ChannelState.KEY).get();
    }

    private static final class ChannelState {
        private static final AttributeKey<ChannelState> KEY = AttributeKey.valueOf(NettyHandlerAdapter.class, (String)"channel");
        @Nullable
        Queue<Object> messageQueue;
        @Nullable
        X509Certificate clientCert;
        @Nullable
        Action<Object> rawSubscriber;
        ResponseTransmitter responseTransmitter;
        RequestBody requestBody;
        boolean requestedNextRequest;
        final ConnectionIdleTimeout idleTimeout;

        ChannelState(ConnectionIdleTimeout idleTimeout) {
            this.idleTimeout = idleTimeout;
        }
    }
}

