/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import ratpack.sse.ServerSentEvent;

public class ServerSentEventEncoder {
    private static final byte[] EVENT_PREFIX = ServerSentEventEncoder.utf8Bytes("event: ");
    private static final byte[] DATA_PREFIX_POOL = ServerSentEventEncoder.utf8Bytes("data: ");
    private static final byte[] ID_PREFIX = ServerSentEventEncoder.utf8Bytes("id: ");
    private static final byte[] COMMENT_PREFIX = ServerSentEventEncoder.utf8Bytes(": ");
    private static final byte NEWLINE = 10;

    public static void encodeTo(ServerSentEvent sse, ByteBuf buffer) {
        ServerSentEventEncoder.writeMulti(buffer, COMMENT_PREFIX, sse.getComment());
        ServerSentEventEncoder.writeSingle(buffer, ID_PREFIX, sse.getId());
        ServerSentEventEncoder.writeSingle(buffer, EVENT_PREFIX, sse.getEvent());
        ServerSentEventEncoder.writeMulti(buffer, DATA_PREFIX_POOL, sse.getData());
        buffer.writeByte(10);
    }

    private static void writeMulti(ByteBuf buffer, byte[] prefix, List<ByteBuf> comment) {
        comment.forEach(commentLine -> {
            buffer.writeBytes(prefix);
            buffer.writeBytes(commentLine);
            buffer.writeByte(10);
        });
    }

    private static void writeSingle(ByteBuf buffer, byte[] prefix, ByteBuf element) {
        if (element.isReadable()) {
            buffer.writeBytes(prefix);
            buffer.writeBytes(element);
            buffer.writeByte(10);
        }
    }

    private static byte[] utf8Bytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }
}

