/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.CharsetUtil;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import org.reactivestreams.Publisher;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.http.HttpMethod;
import ratpack.http.MutableHeaders;
import ratpack.http.client.HttpClient;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;

class RequestConfig {
    final URI uri;
    final HttpMethod method;
    final MutableHeaders headers;
    final Content content;
    final int maxContentLength;
    final Duration connectTimeout;
    final Duration readTimeout;
    final boolean decompressResponse;
    final int maxRedirects;
    final SslContext sslContext;
    final Function<? super ReceivedResponse, Action<? super RequestSpec>> onRedirect;
    final int responseMaxChunkSize;

    static RequestConfig of(URI uri, HttpClient httpClient, Action<? super RequestSpec> action) throws Exception {
        Spec spec = new Spec(uri, httpClient.getByteBufAllocator());
        spec.readTimeout = httpClient.getReadTimeout();
        spec.connectTimeout = httpClient.getConnectTimeout();
        spec.maxContentLength = httpClient.getMaxContentLength();
        spec.responseMaxChunkSize = httpClient.getMaxResponseChunkSize();
        try {
            action.execute((Object)spec);
        }
        catch (Exception any) {
            if (spec.content != null) {
                spec.content.discard();
            }
            throw any;
        }
        return new RequestConfig(spec.uri, spec.method, spec.headers, spec.content, spec.maxContentLength, spec.responseMaxChunkSize, spec.connectTimeout, spec.readTimeout, spec.decompressResponse, spec.maxRedirects, spec.sslContext, (Function<? super ReceivedResponse, Action<? super RequestSpec>>)spec.onRedirect);
    }

    private RequestConfig(URI uri, HttpMethod method, MutableHeaders headers, Content content, int maxContentLength, int responseMaxChunkSize, Duration connectTimeout, Duration readTimeout, boolean decompressResponse, int maxRedirects, SslContext sslContext, Function<? super ReceivedResponse, Action<? super RequestSpec>> onRedirect) {
        this.uri = uri;
        this.method = method;
        this.headers = headers;
        this.content = content;
        this.maxContentLength = maxContentLength;
        this.responseMaxChunkSize = responseMaxChunkSize;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.decompressResponse = decompressResponse;
        this.maxRedirects = maxRedirects;
        this.sslContext = sslContext;
        this.onRedirect = onRedirect;
    }

    static class StreamingContent
    implements Content {
        private final Publisher<? extends ByteBuf> publisher;
        private final long contentLength;

        public StreamingContent(Publisher<? extends ByteBuf> publisher, long contentLength) {
            this.publisher = publisher;
            this.contentLength = contentLength;
        }

        @Override
        public boolean isBuffer() {
            return false;
        }

        @Override
        public ByteBuf buffer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        public Publisher<? extends ByteBuf> publisher() {
            return this.publisher;
        }

        @Override
        public void discard() {
        }
    }

    static class SingleBufferContent
    implements Content {
        private final ByteBuf byteBuf;

        public SingleBufferContent(ByteBuf byteBuf) {
            this.byteBuf = byteBuf;
        }

        @Override
        public long getContentLength() {
            return this.byteBuf.readableBytes();
        }

        @Override
        public boolean isBuffer() {
            return true;
        }

        @Override
        public ByteBuf buffer() {
            return this.byteBuf;
        }

        @Override
        public Publisher<? extends ByteBuf> publisher() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void discard() {
            this.byteBuf.release();
        }
    }

    static interface Content {
        public long getContentLength();

        public boolean isBuffer();

        public ByteBuf buffer();

        public Publisher<? extends ByteBuf> publisher();

        public void discard();
    }

    private static class Spec
    implements RequestSpec {
        private static final SingleBufferContent EMPTY_CONTENT = new SingleBufferContent(Unpooled.EMPTY_BUFFER);
        private final ByteBufAllocator byteBufAllocator;
        private final URI uri;
        private final MutableHeaders headers = new NettyHeadersBackedMutableHeaders((HttpHeaders)new DefaultHttpHeaders());
        private boolean decompressResponse = true;
        private Duration connectTimeout = Duration.ofSeconds(30L);
        private Duration readTimeout = Duration.ofSeconds(30L);
        private int maxContentLength = -1;
        private Content content = EMPTY_CONTENT;
        private HttpMethod method = HttpMethod.GET;
        private int maxRedirects = 10;
        private SslContext sslContext;
        private Function<? super ReceivedResponse, Action<? super RequestSpec>> onRedirect;
        private final BodyImpl body = new BodyImpl();
        private int responseMaxChunkSize = 8192;

        Spec(URI uri, ByteBufAllocator byteBufAllocator) {
            this.uri = uri;
            this.byteBufAllocator = byteBufAllocator;
        }

        @Override
        public RequestSpec onRedirect(Function<? super ReceivedResponse, Action<? super RequestSpec>> function) {
            this.onRedirect = function;
            return this;
        }

        @Override
        public RequestSpec redirects(int maxRedirects) {
            Preconditions.checkArgument((maxRedirects >= 0 ? 1 : 0) != 0);
            this.maxRedirects = maxRedirects;
            return this;
        }

        @Override
        public int getRedirects() {
            return this.maxRedirects;
        }

        @Override
        public RequestSpec sslContext(SSLContext sslContext) {
            this.sslContext = new JdkSslContext(sslContext, true, ClientAuth.NONE);
            return this;
        }

        @Override
        public RequestSpec sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @Override
        public SslContext getSslContext() {
            return this.sslContext;
        }

        @Override
        public MutableHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public RequestSpec maxContentLength(int numBytes) {
            this.maxContentLength = numBytes;
            return this;
        }

        @Override
        public RequestSpec responseMaxChunkSize(int numBytes) {
            if (numBytes < 1) {
                throw new IllegalArgumentException("numBytes must be > 0");
            }
            this.responseMaxChunkSize = numBytes;
            return this;
        }

        @Override
        public int getMaxContentLength() {
            return this.maxContentLength;
        }

        @Override
        public RequestSpec headers(Action<? super MutableHeaders> action) throws Exception {
            action.execute((Object)this.getHeaders());
            return this;
        }

        @Override
        public RequestSpec method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @Override
        public HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public RequestSpec decompressResponse(boolean shouldDecompress) {
            this.decompressResponse = shouldDecompress;
            return this;
        }

        @Override
        public boolean getDecompressResponse() {
            return this.decompressResponse;
        }

        @Override
        public RequestSpec connectTimeout(Duration duration) {
            this.connectTimeout = duration;
            return this;
        }

        @Override
        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        @Override
        public RequestSpec readTimeout(Duration duration) {
            this.readTimeout = duration;
            return this;
        }

        @Override
        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        private void setContent(Content content) {
            if (this.content != null) {
                this.content.discard();
            }
            this.content = content;
        }

        @Override
        public RequestSpec.Body getBody() {
            return this.body;
        }

        @Override
        public RequestSpec body(Action<? super RequestSpec.Body> action) throws Exception {
            action.execute((Object)this.getBody());
            return this;
        }

        private class BodyImpl
        implements RequestSpec.Body {
            private BodyImpl() {
            }

            @Override
            public RequestSpec.Body type(CharSequence contentType) {
                Spec.this.getHeaders().set(HttpHeaderConstants.CONTENT_TYPE, contentType);
                return this;
            }

            @Override
            public RequestSpec.Body stream(Action<? super OutputStream> action) throws Exception {
                ByteBuf byteBuf = Spec.this.byteBufAllocator.buffer();
                try (ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);){
                    action.execute((Object)outputStream);
                }
                catch (Throwable t) {
                    byteBuf.release();
                    throw t;
                }
                return this.buffer(byteBuf);
            }

            @Override
            public RequestSpec.Body streamUnknownLength(Publisher<? extends ByteBuf> publisher) {
                Spec.this.setContent(new StreamingContent(publisher, -1L));
                return this;
            }

            @Override
            public RequestSpec.Body stream(Publisher<? extends ByteBuf> publisher, long contentLength) {
                if (contentLength < 1L) {
                    throw new IllegalArgumentException("contentLength must be > 0");
                }
                Spec.this.setContent(new StreamingContent(publisher, contentLength));
                return this;
            }

            @Override
            public RequestSpec.Body buffer(ByteBuf byteBuf) {
                Spec.this.setContent(new SingleBufferContent(byteBuf));
                return this;
            }

            @Override
            public RequestSpec.Body bytes(byte[] bytes) {
                return this.buffer(Unpooled.wrappedBuffer((byte[])bytes));
            }

            @Override
            public RequestSpec.Body text(CharSequence text) {
                return this.text(text, CharsetUtil.UTF_8);
            }

            @Override
            public RequestSpec.Body text(CharSequence text, Charset charset) {
                if (charset.equals(CharsetUtil.UTF_8)) {
                    this.maybeSetContentType(HttpHeaderConstants.PLAIN_TEXT_UTF8);
                } else {
                    this.maybeSetContentType("text/plain;charset=" + charset.name());
                }
                return this.buffer(Unpooled.copiedBuffer((CharSequence)text, (Charset)charset));
            }

            private void maybeSetContentType(CharSequence s) {
                if (!Spec.this.headers.contains(HttpHeaderConstants.CONTENT_TYPE.toString())) {
                    Spec.this.headers.set(HttpHeaderConstants.CONTENT_TYPE, s);
                }
            }
        }
    }
}

