/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import ratpack.api.NonBlocking;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.handling.ByContentSpec;
import ratpack.handling.ByMethodSpec;
import ratpack.handling.Handler;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.TypedData;
import ratpack.parse.Parse;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.render.NoSuchRendererException;
import ratpack.server.ServerConfig;
import ratpack.util.Types;

public interface Context
extends Registry {
    public static final TypeToken<Context> TYPE = Types.token(Context.class);

    public Context getContext();

    public Execution getExecution();

    public ServerConfig getServerConfig();

    public Request getRequest();

    public Response getResponse();

    @NonBlocking
    public void next();

    @NonBlocking
    public void next(Registry var1);

    public void insert(Handler var1);

    @NonBlocking
    public void insert(Handler ... var1);

    public void insert(Registry var1, Handler var2);

    @NonBlocking
    public void insert(Registry var1, Handler ... var2);

    @NonBlocking
    public void byMethod(Action<? super ByMethodSpec> var1) throws Exception;

    public void byContent(Action<? super ByContentSpec> var1) throws Exception;

    @NonBlocking
    public void error(Throwable var1);

    @NonBlocking
    public void clientError(int var1) throws NotInRegistryException;

    @NonBlocking
    public void render(Object var1) throws NoSuchRendererException;

    default public Optional<String> header(CharSequence name) {
        return Optional.ofNullable(this.getRequest().getHeaders().get(name));
    }

    default public Context header(CharSequence name, Object ... values) {
        this.getResponse().getHeaders().set(name, Arrays.asList(values));
        return this;
    }

    default public void redirect(String to) {
        this.redirect((Object)to);
    }

    default public void redirect(int code, String to) {
        this.redirect(code, (Object)to);
    }

    default public void redirect(URI to) {
        this.redirect((Object)to);
    }

    default public void redirect(int code, URI to) {
        this.redirect(code, to.toASCIIString());
    }

    public void redirect(Object var1);

    public void redirect(int var1, Object var2);

    @NonBlocking
    default public void lastModified(Date lastModified, Runnable serve) {
        this.lastModified(lastModified.toInstant(), serve);
    }

    @NonBlocking
    public void lastModified(Instant var1, Runnable var2);

    public <T> Promise<T> parse(Class<T> var1);

    public <T> Promise<T> parse(TypeToken<T> var1);

    public <T, O> Promise<T> parse(Class<T> var1, O var2);

    public <T, O> Promise<T> parse(TypeToken<T> var1, O var2);

    public <T, O> Promise<T> parse(Parse<T, O> var1);

    public <T, O> T parse(TypedData var1, Parse<T, O> var2) throws Exception;

    public DirectChannelAccess getDirectChannelAccess();

    public PathBinding getPathBinding();

    default public PathTokens getPathTokens() throws NotInRegistryException {
        return this.getPathBinding().getTokens();
    }

    default public PathTokens getAllPathTokens() throws NotInRegistryException {
        return this.getPathBinding().getAllTokens();
    }

    public void onClose(Action<? super RequestOutcome> var1);

    public Path file(String var1) throws NotInRegistryException;

    default public FileSystemBinding getFileSystemBinding() {
        return (FileSystemBinding)this.get(FileSystemBinding.TYPE);
    }

    default public void notFound() {
        this.clientError(404);
    }
}

