/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import io.netty.handler.codec.http.HttpResponseStatus;
import ratpack.http.ClientErrorException;

public class RequestBodyTooLargeException
extends ClientErrorException {
    private final long maxContentLength;
    private final long receivedContentLength;

    public RequestBodyTooLargeException(long maxContentLength, long receivedContentLength) {
        super("the request content length of " + receivedContentLength + " exceeded the allowed maximum of " + maxContentLength);
        this.maxContentLength = maxContentLength;
        this.receivedContentLength = receivedContentLength;
    }

    public long getMaxContentLength() {
        return this.maxContentLength;
    }

    public long getReceivedContentLength() {
        return this.receivedContentLength;
    }

    @Override
    public int getClientErrorCode() {
        return HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.code();
    }
}

