/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import ratpack.exec.ExecController;
import ratpack.file.FileSystemBinding;
import ratpack.server.ServerConfig;

public class ServerConfigData {
    private final FileSystemBinding baseDir;
    private ExecController execController;
    private int port;
    private InetAddress address;
    private boolean development;
    private int threads = ServerConfig.DEFAULT_THREADS;
    private URI publicAddress;
    private SslContext sslContext;
    private boolean requireClientSslAuth;
    private int maxContentLength = 0x100000;
    private Optional<Integer> connectTimeoutMillis = Optional.empty();
    private Optional<Integer> maxMessagesPerRead = Optional.empty();
    private Optional<Integer> receiveBufferSize = Optional.empty();
    private Optional<Integer> writeSpinCount = Optional.empty();
    private Optional<Integer> connectQueueSize = Optional.empty();
    private Optional<Path> portFile = Optional.empty();
    private int maxChunkSize = 8192;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private Duration idleTimeout = Duration.ZERO;
    private boolean registerShutdownHook = true;
    private boolean tcpKeepAlive;

    public ServerConfigData(FileSystemBinding baseDir, InetAddress address, int port, boolean development, URI publicAddress) {
        this.baseDir = baseDir;
        this.address = address;
        this.port = port;
        this.development = development;
        this.publicAddress = publicAddress;
    }

    @Nullable
    public ExecController getExecController() {
        return this.execController;
    }

    public void setExecController(ExecController execController) {
        this.execController = execController;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public boolean isDevelopment() {
        return this.development;
    }

    public int getThreads() {
        return this.threads;
    }

    public URI getPublicAddress() {
        return this.publicAddress;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public Optional<Integer> getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public Optional<Integer> getMaxMessagesPerRead() {
        return this.maxMessagesPerRead;
    }

    public Optional<Integer> getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Optional<Integer> getWriteSpinCount() {
        return this.writeSpinCount;
    }

    public Optional<Path> getPortFile() {
        return this.portFile;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setAddress(String host) throws UnknownHostException {
        this.setAddress(InetAddress.getByName(host));
    }

    public void setDevelopment(boolean development) {
        this.development = development;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setPublicAddress(URI publicAddress) {
        this.publicAddress = publicAddress;
    }

    public void setPublicAddress(String publicAddress) throws URISyntaxException {
        this.publicAddress = new URI(publicAddress);
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public boolean isRequireClientSslAuth() {
        return this.requireClientSslAuth;
    }

    public void setRequireClientSslAuth(boolean requireClientSslAuth) {
        this.requireClientSslAuth = requireClientSslAuth;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = Optional.of(connectTimeoutMillis);
    }

    public void setMaxMessagesPerRead(int maxMessagesPerRead) {
        this.maxMessagesPerRead = Optional.of(maxMessagesPerRead);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = Optional.of(receiveBufferSize);
    }

    public void setWriteSpinCount(int writeSpinCount) {
        this.writeSpinCount = Optional.of(writeSpinCount);
    }

    public void setPortFile(Path portFile) {
        this.portFile = Optional.ofNullable(portFile);
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public void setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public void setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public FileSystemBinding getBaseDir() {
        return this.baseDir;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Duration idleTimeout) {
        if (idleTimeout == null) {
            throw new IllegalArgumentException("idleTimeout must not be null");
        }
        if (idleTimeout.isNegative()) {
            throw new IllegalArgumentException("idleTimeout must not be negative");
        }
        this.idleTimeout = idleTimeout;
    }

    public void setConnectQueueSize(Integer integer) {
        this.connectQueueSize = Optional.of(integer);
    }

    public Optional<Integer> getConnectQueueSize() {
        return this.connectQueueSize;
    }

    public boolean isRegisterShutdownHook() {
        return this.registerShutdownHook;
    }

    public void setRegisterShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
    }
}

