/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.List;
import ratpack.handling.Context;
import ratpack.handling.Handler;

public class ChainHandler
implements Handler {
    private final Handler[] handlers;

    public ChainHandler(List<? extends Handler> handlers) {
        if (handlers.size() < 2) {
            throw new IllegalArgumentException("handlers size must be >= 2");
        }
        this.handlers = handlers.toArray(new Handler[0]);
    }

    public ChainHandler(Handler ... handlers) {
        this.handlers = handlers;
    }

    public static Handler[] unpack(Handler handler) {
        if (handler instanceof ChainHandler) {
            return ((ChainHandler)handler).handlers;
        }
        return new Handler[]{handler};
    }

    @Override
    public void handle(Context context) {
        context.insert(this.handlers);
    }

    public Handler[] getHandlers() {
        return this.handlers;
    }
}

