/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.cookie.Cookie;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import ratpack.api.NonBlocking;
import ratpack.func.Action;
import ratpack.http.MutableHeaders;
import ratpack.http.Status;
import ratpack.util.Types;

@NonBlocking
public interface Response {
    public static final TypeToken<Response> TYPE = Types.token(Response.class);

    public Cookie cookie(String var1, String var2);

    public Cookie expireCookie(String var1);

    public Set<Cookie> getCookies();

    public MutableHeaders getHeaders();

    public Status getStatus();

    default public Response status(int code) {
        return this.status(Status.of(code));
    }

    public Response status(Status var1);

    public void send();

    public Response contentTypeIfNotSet(Supplier<CharSequence> var1);

    public void send(String var1);

    public void send(CharSequence var1, String var2);

    public void send(byte[] var1);

    public void send(CharSequence var1, byte[] var2);

    public void send(ByteBuf var1);

    public void send(CharSequence var1, ByteBuf var2);

    public Response contentType(CharSequence var1);

    default public Response contentTypeIfNotSet(CharSequence contentType) {
        return this.contentTypeIfNotSet(() -> contentType);
    }

    public void sendFile(Path var1);

    public void sendStream(Publisher<? extends ByteBuf> var1);

    public Response beforeSend(@NonBlocking Action<? super Response> var1);

    public Response noCompress();

    default public Response forceCloseConnection() {
        this.getHeaders().set((CharSequence)HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE);
        return this;
    }
}

