/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponse;
import java.util.Objects;
import java.util.stream.Stream;
import ratpack.http.internal.HttpHeaderConstants;

public class IgnorableHttpContentCompressor
extends HttpContentCompressor {
    public IgnorableHttpContentCompressor() {
        super((CompressionOptions[])Stream.of(Brotli.isAvailable() ? StandardCompressionOptions.brotli() : null, StandardCompressionOptions.deflate(), StandardCompressionOptions.gzip(), Zstd.isAvailable() ? StandardCompressionOptions.zstd((int)3, (int)65536, (int)Integer.MAX_VALUE) : null).filter(Objects::nonNull).toArray(CompressionOptions[]::new));
    }

    protected HttpContentEncoder.Result beginEncode(HttpResponse res, String acceptEncoding) throws Exception {
        String contentEncoding = res.headers().getAsString(HttpHeaderConstants.CONTENT_ENCODING);
        if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            res.headers().remove(HttpHeaderConstants.CONTENT_ENCODING);
            return null;
        }
        return super.beginEncode(res, acceptEncoding);
    }
}

