/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.channel.EventLoop;
import java.net.URI;
import java.time.Duration;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;

final class HttpChannelKey {
    final boolean ssl;
    final int port;
    final String host;
    final ExecController execController;
    final EventLoop eventLoop;
    final Duration connectTimeout;

    HttpChannelKey(URI uri, Duration connectTimeout, Execution execution) {
        switch (uri.getScheme()) {
            case "https": {
                this.ssl = true;
                break;
            }
            case "http": {
                this.ssl = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("URI " + uri + " is not HTTP or HTTPS");
            }
        }
        this.port = uri.getPort() < 0 ? (this.ssl ? 443 : 80) : uri.getPort();
        this.host = uri.getHost();
        this.execController = execution.getController();
        this.eventLoop = execution.getEventLoop();
        this.connectTimeout = connectTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpChannelKey that = (HttpChannelKey)o;
        return this.execController == that.execController && this.ssl == that.ssl && this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.ssl ? 1 : 0;
        result = 31 * result + this.port;
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.execController.hashCode();
        return result;
    }
}

