/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import com.google.common.net.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.exec.Upstream;
import ratpack.exec.internal.DefaultExecution;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.http.client.HttpClientReadTimeoutException;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.HttpClientInternal;
import ratpack.http.client.internal.RequestConfig;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultMediaType;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;

abstract class RequestActionSupport<T>
implements Upstream<T> {
    private static final String SSL_HANDLER_NAME = "ssl";
    private static final String CLIENT_CODEC_HANDLER_NAME = "clientCodec";
    private static final String READ_TIMEOUT_HANDLER_NAME = "readTimeout";
    private static final String REDIRECT_HANDLER_NAME = "redirect";
    private static final String DECOMPRESS_HANDLER_NAME = "decompressor";
    private static final String WRITABILITY_HANDLER_NAME = "writability";
    protected final HttpClientInternal client;
    protected final RequestConfig requestConfig;
    protected final Execution execution;
    private final HttpChannelKey channelKey;
    private final ChannelPool channelPool;
    private final int redirectCount;
    private final Action<? super RequestSpec> requestConfigurer;
    private boolean fired;
    private boolean disposed;
    private boolean expectContinue;
    private boolean receivedContinue;
    private boolean streamingBody;
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private Runnable onWritabilityChanged = NOOP_RUNNABLE;

    RequestActionSupport(URI uri, HttpClientInternal client, int redirectCount, boolean expectContinue, Execution execution, Action<? super RequestSpec> requestConfigurer) throws Exception {
        this.requestConfigurer = requestConfigurer;
        this.requestConfig = RequestConfig.of(uri, client, requestConfigurer);
        this.client = client;
        this.execution = execution;
        this.redirectCount = redirectCount;
        this.expectContinue = expectContinue;
        this.channelKey = new HttpChannelKey(this.requestConfig.uri, this.requestConfig.connectTimeout, execution);
        this.channelPool = client.getChannelPoolMap().get((Object)this.channelKey);
        this.finalizeHeaders();
    }

    protected abstract void addResponseHandlers(ChannelPipeline var1, Downstream<? super T> var2);

    public void connect(Downstream<? super T> downstream) throws Exception {
        this.channelPool.acquire().addListener(acquireFuture -> {
            if (acquireFuture.isSuccess()) {
                Channel channel = (Channel)acquireFuture.getNow();
                channel.config().setAutoClose(false);
                if (channel.eventLoop().equals(this.execution.getEventLoop())) {
                    this.send(downstream, channel);
                } else {
                    channel.deregister().addListener(deregisterFuture -> this.execution.getEventLoop().register(channel).addListener(registerFuture -> {
                        if (registerFuture.isSuccess()) {
                            this.send(downstream, channel);
                        } else {
                            channel.close();
                            this.channelPool.release(channel);
                            this.connectFailure(downstream, registerFuture.cause());
                        }
                    }));
                }
            } else {
                this.connectFailure(downstream, acquireFuture.cause());
            }
        });
    }

    private void send(Downstream<? super T> downstream, Channel channel) throws Exception {
        Object request;
        channel.config().setAutoRead(true);
        this.expectContinue = this.requestConfig.headers.getNettyHeaders().contains((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE, true);
        boolean streamedBody = !this.requestConfig.content.isBuffer();
        String requestUri = RequestActionSupport.getFullPath(this.requestConfig.uri);
        if (this.requestConfig.content.getContentLength() == 0L) {
            this.requestConfig.content.discard();
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, this.requestConfig.method.getNettyMethod(), requestUri, Unpooled.EMPTY_BUFFER, this.requestConfig.headers.getNettyHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        } else {
            request = !this.expectContinue && !streamedBody ? new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, this.requestConfig.method.getNettyMethod(), requestUri, this.requestConfig.content.buffer(), this.requestConfig.headers.getNettyHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE) : new DefaultHttpRequest(HttpVersion.HTTP_1_1, this.requestConfig.method.getNettyMethod(), requestUri, this.requestConfig.headers.getNettyHeaders());
        }
        HttpUtil.setTransferEncodingChunked((HttpMessage)request, (streamedBody && this.requestConfig.content.getContentLength() < 0L ? 1 : 0) != 0);
        this.addCommonResponseHandlers(channel.pipeline(), downstream);
        Object channelFuture = this.channelKey.ssl ? ((SslHandler)channel.pipeline().get(SslHandler.class)).handshakeFuture() : channel.newSucceededFuture();
        channelFuture.addListener(arg_0 -> this.lambda$send$7(channel, (HttpMessage)request, streamedBody, downstream, arg_0));
    }

    private void sendRequestBody(Downstream<? super T> downstream, Channel channel) {
        RequestConfig.Content content = this.requestConfig.content;
        if (content.isBuffer()) {
            channel.writeAndFlush((Object)new DefaultLastHttpContent(content.buffer())).addListener(future -> {
                if (!future.isSuccess() && channel.isOpen()) {
                    this.forceDispose(channel.pipeline());
                    downstream.error(future.cause());
                }
            });
        } else {
            this.sendRequestBodyStream(downstream, channel, content.publisher());
        }
    }

    private void sendRequestBodyStream(final Downstream<? super T> downstream, final Channel channel, Publisher<? extends ByteBuf> publisher) {
        this.streamingBody = true;
        ((DefaultExecution)this.execution).delimit(arg_0 -> downstream.error(arg_0), continuation -> continuation.resume(() -> publisher.subscribe((Subscriber)new Subscriber<ByteBuf>(){
            private Subscription subscription;
            private final AtomicBoolean done = new AtomicBoolean();
            private long pending;
            private final GenericFutureListener cancelOnCloseListener;
            {
                this.pending = RequestActionSupport.this.requestConfig.content.getContentLength();
                this.cancelOnCloseListener = c -> this.cancel();
            }

            private void cancel() {
                this.subscription.cancel();
                this.reset();
            }

            public void onSubscribe(Subscription subscription) {
                if (subscription == null) {
                    throw new NullPointerException("'subscription' is null");
                }
                if (this.subscription != null) {
                    subscription.cancel();
                    return;
                }
                this.subscription = subscription;
                if (channel.isOpen()) {
                    channel.closeFuture().addListener(this.cancelOnCloseListener);
                    if (channel.isWritable()) {
                        this.subscription.request(1L);
                    }
                    RequestActionSupport.this.onWritabilityChanged = () -> {
                        if (channel.isWritable() && !this.done.get()) {
                            this.subscription.request(1L);
                        }
                    };
                } else {
                    this.cancel();
                }
            }

            public void onNext(ByteBuf o) {
                o.touch();
                if (!channel.isOpen()) {
                    o.release();
                    this.cancel();
                    return;
                }
                if (this.pending == 0L) {
                    o.release();
                    this.subscription.request(1L);
                    return;
                }
                int chunkSize = o.readableBytes();
                if (this.pending > 0L) {
                    if ((long)chunkSize > this.pending) {
                        chunkSize = (int)this.pending;
                        o = o.slice(0, chunkSize);
                    }
                    this.pending -= (long)chunkSize;
                }
                channel.write((Object)new DefaultHttpContent(o));
                if (channel.isWritable()) {
                    this.subscription.request(1L);
                } else {
                    channel.flush();
                }
            }

            public void onError(Throwable t) {
                if (t == null) {
                    throw new NullPointerException("error is null");
                }
                this.reset();
                RequestActionSupport.this.forceDispose(channel.pipeline()).addListener(future -> {
                    if (!future.isSuccess()) {
                        t.addSuppressed(future.cause());
                    }
                    downstream.error(t);
                });
            }

            public void onComplete() {
                if (this.done.compareAndSet(false, true)) {
                    if (this.pending > 0L) {
                        this.reset();
                        channel.flush();
                        RequestActionSupport.this.forceDispose(channel.pipeline()).addListener(future -> {
                            IllegalStateException t = new IllegalStateException("Publisher completed before sending advertised number of bytes");
                            if (!future.isSuccess()) {
                                t.addSuppressed(future.cause());
                            }
                            downstream.error((Throwable)t);
                        });
                    } else {
                        this.reset();
                        channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                    }
                }
            }

            private void reset() {
                if (this.done.compareAndSet(false, true)) {
                    RequestActionSupport.this.onWritabilityChanged = NOOP_RUNNABLE;
                    channel.closeFuture().removeListener(this.cancelOnCloseListener);
                    RequestActionSupport.this.streamingBody = false;
                }
            }
        })));
    }

    private void connectFailure(Downstream<? super T> downstream, Throwable e) {
        this.requestConfig.content.discard();
        if (e instanceof ConnectTimeoutException) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            e = new ConnectTimeoutException("Connect timeout (" + this.requestConfig.connectTimeout + ") connecting to " + this.requestConfig.uri);
            e.setStackTrace(stackTrace);
        }
        downstream.error(e);
    }

    private void finalizeHeaders() {
        long contentLength;
        if (this.requestConfig.headers.get(HttpHeaderConstants.HOST) == null) {
            HostAndPort hostAndPort = HostAndPort.fromParts((String)this.channelKey.host, (int)this.channelKey.port);
            this.requestConfig.headers.set(HttpHeaderConstants.HOST, hostAndPort.toString());
        }
        if (this.client.getPoolSize() == 0) {
            this.requestConfig.headers.set(HttpHeaderConstants.CONNECTION, HttpHeaderValues.CLOSE);
        }
        if ((contentLength = this.requestConfig.content.getContentLength()) > 0L) {
            this.requestConfig.headers.set(HttpHeaderConstants.CONTENT_LENGTH, Long.toString(contentLength));
        }
    }

    protected Future<Void> forceDispose(ChannelPipeline channelPipeline) {
        return this.dispose(channelPipeline, true);
    }

    protected Future<Void> dispose(ChannelPipeline channelPipeline, HttpResponse response) {
        return this.dispose(channelPipeline, !HttpUtil.isKeepAlive((HttpMessage)response) || this.streamingBody);
    }

    private Future<Void> dispose(ChannelPipeline channelPipeline, boolean forceClose) {
        if (this.disposed) {
            return this.execution.getEventLoop().newSucceededFuture(null);
        }
        this.disposed = true;
        return this.doDispose(channelPipeline, forceClose);
    }

    protected Future<Void> doDispose(ChannelPipeline channelPipeline, boolean forceClose) {
        channelPipeline.remove(CLIENT_CODEC_HANDLER_NAME);
        channelPipeline.remove(READ_TIMEOUT_HANDLER_NAME);
        channelPipeline.remove(REDIRECT_HANDLER_NAME);
        channelPipeline.remove(WRITABILITY_HANDLER_NAME);
        if (channelPipeline.get(DECOMPRESS_HANDLER_NAME) != null) {
            channelPipeline.remove(DECOMPRESS_HANDLER_NAME);
        }
        Channel channel = channelPipeline.channel();
        if (forceClose && channel.isOpen()) {
            channel.close();
        }
        channel.config().setAutoClose(true);
        return this.channelPool.release(channel);
    }

    private void addCommonResponseHandlers(ChannelPipeline p, final Downstream<? super T> downstream) throws Exception {
        if (this.channelKey.ssl && p.get(SSL_HANDLER_NAME) == null) {
            p.addLast(SSL_HANDLER_NAME, (ChannelHandler)this.createSslHandler());
        }
        p.addLast(CLIENT_CODEC_HANDLER_NAME, (ChannelHandler)new HttpClientCodec(4096, 8192, this.requestConfig.responseMaxChunkSize, false));
        p.addLast(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler(this.requestConfig.readTimeout.toNanos(), TimeUnit.NANOSECONDS));
        p.addLast(REDIRECT_HANDLER_NAME, (ChannelHandler)new SimpleChannelInboundHandler<HttpObject>(false){
            boolean redirected;
            HttpResponse response;

            public void channelInactive(ChannelHandlerContext ctx) {
                ctx.fireExceptionCaught((Throwable)new PrematureChannelClosureException("Server " + RequestActionSupport.this.requestConfig.uri + " closed the connection prematurely"));
            }

            protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                if (msg instanceof LastHttpContent && RequestActionSupport.this.expectContinue && RequestActionSupport.this.receivedContinue) {
                    RequestActionSupport.this.expectContinue = false;
                    RequestActionSupport.this.receivedContinue = false;
                    RequestActionSupport.this.sendRequestBody(downstream, ctx.channel());
                    return;
                }
                if (msg instanceof HttpResponse) {
                    this.response = (HttpResponse)msg;
                    int status = this.response.status().code();
                    if (RequestActionSupport.this.expectContinue) {
                        if (status == HttpResponseStatus.CONTINUE.code()) {
                            RequestActionSupport.this.receivedContinue = true;
                            return;
                        }
                        if (!RequestActionSupport.isRedirect(status)) {
                            RequestActionSupport.this.expectContinue = false;
                        }
                    }
                    int maxRedirects = RequestActionSupport.this.requestConfig.maxRedirects;
                    String locationValue = this.response.headers().getAsString(HttpHeaderConstants.LOCATION);
                    Object redirectConfigurer = RequestActionSupport.this.requestConfigurer;
                    if (RequestActionSupport.isRedirect(status) && RequestActionSupport.this.redirectCount < maxRedirects && locationValue != null) {
                        Function<? super ReceivedResponse, Action<? super RequestSpec>> onRedirect = RequestActionSupport.this.requestConfig.onRedirect;
                        if (onRedirect != null) {
                            Action onRedirectResult = (Action)((DefaultExecution)RequestActionSupport.this.execution).runSync(() -> (Action)onRedirect.apply((Object)RequestActionSupport.this.toReceivedResponse(this.response)));
                            redirectConfigurer = onRedirectResult == null ? null : redirectConfigurer.append(onRedirectResult);
                        }
                        if (redirectConfigurer != null) {
                            Action redirectRequestConfig = s -> {
                                if (status == 301 || status == 302) {
                                    s.get();
                                }
                            };
                            Action finalRedirectRequestConfig = redirectConfigurer.append(redirectRequestConfig);
                            Action executionBoundRedirectRequestConfig = request -> ((DefaultExecution)RequestActionSupport.this.execution).runSync(() -> {
                                finalRedirectRequestConfig.execute(request);
                                return null;
                            });
                            URI locationUri = RequestActionSupport.absolutizeRedirect(RequestActionSupport.this.requestConfig.uri, locationValue);
                            this.redirected = true;
                            Future<Void> dispose = RequestActionSupport.this.dispose(ctx.pipeline(), this.response);
                            dispose.addListener(future -> {
                                if (future.isSuccess()) {
                                    RequestActionSupport.this.onRedirect(locationUri, RequestActionSupport.this.redirectCount + 1, RequestActionSupport.this.expectContinue, (Action<RequestSpec>)executionBoundRedirectRequestConfig).connect(downstream);
                                } else {
                                    downstream.error(future.cause());
                                }
                            });
                        }
                    }
                }
                if (!this.redirected) {
                    ctx.fireChannelRead((Object)msg);
                }
            }
        });
        if (this.requestConfig.decompressResponse) {
            p.addLast(DECOMPRESS_HANDLER_NAME, (ChannelHandler)new HttpContentDecompressor());
        }
        p.addLast(WRITABILITY_HANDLER_NAME, (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                RequestActionSupport.this.onWritabilityChanged.run();
                super.channelWritabilityChanged(ctx);
            }
        });
        this.addResponseHandlers(p, downstream);
    }

    private SslHandler createSslHandler() throws SSLException {
        SSLEngine sslEngine = this.requestConfig.sslContext != null ? this.createSslEngine(this.requestConfig.sslContext) : this.createSslEngine(SslContextBuilder.forClient().build());
        sslEngine.setUseClientMode(true);
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
        return new SslHandler(sslEngine);
    }

    private SSLEngine createSslEngine(SslContext sslContext) {
        int port = this.requestConfig.uri.getPort();
        if (port == -1) {
            port = 443;
        }
        return sslContext.newEngine(this.client.getByteBufAllocator(), this.requestConfig.uri.getHost(), port);
    }

    protected abstract Upstream<T> onRedirect(URI var1, int var2, boolean var3, Action<? super RequestSpec> var4) throws Exception;

    protected void error(Downstream<?> downstream, Throwable error) {
        if (!this.fired && !this.disposed) {
            this.fired = true;
            downstream.error(error);
        }
    }

    private ReceivedResponse toReceivedResponse(HttpResponse msg) {
        return this.toReceivedResponse(msg, Unpooled.EMPTY_BUFFER);
    }

    protected ReceivedResponse toReceivedResponse(HttpResponse msg, ByteBuf responseBuffer) {
        responseBuffer.touch();
        NettyHeadersBackedHeaders headers = new NettyHeadersBackedHeaders(msg.headers());
        String contentType = headers.get(HttpHeaderConstants.CONTENT_TYPE);
        ByteBufBackedTypedData typedData = new ByteBufBackedTypedData(responseBuffer, DefaultMediaType.get(contentType));
        DefaultStatus status = new DefaultStatus(msg.status());
        return new DefaultReceivedResponse(status, headers, typedData);
    }

    private static boolean isRedirect(int code) {
        return code == 301 || code == 302 || code == 303 || code == 307;
    }

    protected Throwable decorateException(Throwable cause) {
        if (cause instanceof ReadTimeoutException) {
            cause = new HttpClientReadTimeoutException("Read timeout (" + this.requestConfig.readTimeout + ") waiting on HTTP server at " + this.requestConfig.uri);
        }
        return cause;
    }

    private static String getFullPath(URI uri) {
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        String fragment = uri.getRawFragment();
        if (query == null && fragment == null) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path);
        if (query != null) {
            sb.append("?").append(query);
        }
        if (fragment != null) {
            sb.append("#").append(fragment);
        }
        return sb.toString();
    }

    private static URI absolutizeRedirect(URI requestUri, String redirectLocation) throws URISyntaxException {
        URI redirectLocationUri = URI.create(redirectLocation);
        if (redirectLocation.startsWith("http://") || redirectLocation.startsWith("https://")) {
            return redirectLocationUri;
        }
        if (redirectLocation.startsWith("//")) {
            return URI.create(requestUri.getScheme() + ":" + redirectLocation);
        }
        String path = redirectLocationUri.getPath();
        if (!path.startsWith("/")) {
            path = RequestActionSupport.getParentPath(requestUri.getPath()) + path;
        }
        return new URI(requestUri.getScheme(), requestUri.getUserInfo(), requestUri.getHost(), requestUri.getPort(), path, redirectLocationUri.getQuery(), null);
    }

    private static String getParentPath(String path) {
        String parentPath = "/";
        int indexOfSlash = path.lastIndexOf(47);
        if (indexOfSlash >= 0) {
            parentPath = path.substring(0, indexOfSlash) + '/';
        }
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        return parentPath;
    }

    private /* synthetic */ void lambda$send$7(Channel channel, HttpMessage request, boolean streamedBody, Downstream downstream, Future firstFuture) throws Exception {
        if (firstFuture.isSuccess()) {
            channel.writeAndFlush((Object)request).addListener(writeFuture -> {
                if (writeFuture.isSuccess()) {
                    if (!this.expectContinue && streamedBody) {
                        this.sendRequestBodyStream(downstream, channel, this.requestConfig.content.publisher());
                    }
                } else {
                    this.forceDispose(channel.pipeline()).addListener(disposeFuture -> {
                        if (!disposeFuture.isSuccess()) {
                            writeFuture.cause().addSuppressed(disposeFuture.cause());
                        }
                        downstream.error(writeFuture.cause());
                    });
                }
            });
        } else {
            this.forceDispose(channel.pipeline()).addListener(disposeFuture -> {
                if (!disposeFuture.isSuccess()) {
                    firstFuture.cause().addSuppressed(disposeFuture.cause());
                }
                downstream.error(firstFuture.cause());
            });
        }
    }
}

