/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.util.Optional;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.registry.Registry;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;

public final class RatpackServerDefinition {
    public final ServerConfig serverConfig;
    public final Function<? super Registry, ? extends Registry> registry;
    public final Function<? super Registry, ? extends Handler> handler;

    private RatpackServerDefinition(ServerConfig serverConfig, Function<? super Registry, ? extends Registry> registry, Function<? super Registry, ? extends Handler> handler) {
        this.serverConfig = serverConfig;
        this.registry = registry;
        this.handler = handler;
    }

    public static RatpackServerDefinition build(Action<? super RatpackServerSpec> config) throws Exception {
        SpecImpl spec = new SpecImpl();
        config.execute((Object)spec);
        ServerConfig serverConfig = Optional.ofNullable(spec.serverConfig).orElseGet(() -> ServerConfig.builder().build());
        return new RatpackServerDefinition(serverConfig, (Function<? super Registry, ? extends Registry>)spec.registry, (Function<? super Registry, ? extends Handler>)spec.handler);
    }

    private static class SpecImpl
    implements RatpackServerSpec {
        private ServerConfig serverConfig;
        private Function<? super Registry, ? extends Registry> registry = r -> Registry.empty();
        private Function<? super Registry, ? extends Handler> handler = r -> Handlers.notFound();

        private SpecImpl() {
        }

        @Override
        public RatpackServerSpec registry(Function<? super Registry, ? extends Registry> registry) {
            this.registry = registry;
            return this;
        }

        @Override
        public RatpackServerSpec serverConfig(ServerConfig serverConfig) {
            this.serverConfig = serverConfig;
            return this;
        }

        @Override
        public RatpackServerSpec handler(Function<? super Registry, ? extends Handler> handlerFactory) {
            this.handler = handlerFactory;
            return this;
        }
    }
}

