/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import ratpack.exec.Blocking;
import ratpack.server.internal.ResponseBodyWriter;

class ZeroCopyFileResponseBodyWriter
implements ResponseBodyWriter {
    private static final Set<OpenOption> OPEN_OPTIONS = Collections.singleton(StandardOpenOption.READ);
    private final Path file;
    private final long size;

    ZeroCopyFileResponseBodyWriter(Path file, long size) {
        this.file = file;
        this.size = size;
    }

    @Override
    public ChannelFuture write(Channel channel) {
        ChannelPromise channelPromise = channel.newPromise();
        Blocking.get(() -> FileChannel.open(this.file, OPEN_OPTIONS, new FileAttribute[0])).then(fileChannel -> {
            channel.write((Object)new DefaultFileRegion(fileChannel, 0L, this.size), channel.voidPromise());
            channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT, channelPromise);
            channel.flush();
        });
        return channelPromise;
    }
}

