/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import ratpack.sse.ServerSentEvent;

public class ServerSentEventEncoder {
    public static final ServerSentEventEncoder INSTANCE = new ServerSentEventEncoder();
    private static final byte[] EVENT_TYPE_PREFIX = "event: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] EVENT_DATA_PREFIX = "data: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] EVENT_ID_PREFIX = "id: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] COMMENT_PREFIX = ": ".getBytes(CharsetUtil.UTF_8);
    private static final byte NEWLINE = 10;

    public ByteBuf encode(ServerSentEvent event, ByteBufAllocator bufferAllocator) throws Exception {
        String eventId = event.getId();
        String eventType = event.getEvent();
        String eventData = event.getData();
        String comment = event.getComment();
        int initialCapacity = 0;
        if (eventId != null) {
            initialCapacity += EVENT_ID_PREFIX.length + eventId.length() + 1;
        }
        if (eventType != null) {
            initialCapacity += EVENT_TYPE_PREFIX.length + eventType.length() + 1;
        }
        if (eventData != null) {
            initialCapacity += EVENT_DATA_PREFIX.length + eventData.length() + 1;
        }
        if (comment != null) {
            initialCapacity += COMMENT_PREFIX.length + comment.length() + 1;
        }
        if (initialCapacity == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buffer = bufferAllocator.buffer(initialCapacity + 4096);
        this.writeMultiline(buffer, COMMENT_PREFIX, comment);
        if (eventId != null) {
            buffer.writeBytes(EVENT_ID_PREFIX);
            buffer.writeCharSequence((CharSequence)eventId, StandardCharsets.UTF_8);
            buffer.writeByte(10);
        }
        if (eventType != null) {
            buffer.writeBytes(EVENT_TYPE_PREFIX);
            buffer.writeCharSequence((CharSequence)eventType, StandardCharsets.UTF_8);
            buffer.writeByte(10);
        }
        this.writeMultiline(buffer, EVENT_DATA_PREFIX, eventData);
        return buffer.writeByte(10);
    }

    private void writeMultiline(ByteBuf buffer, byte[] prefix, String value) {
        int from = 0;
        if (value != null) {
            int length = value.length();
            buffer.writeBytes(prefix);
            while (from < length) {
                int to = value.indexOf(10, from);
                if (to == -1) {
                    buffer.writeCharSequence((CharSequence)value.substring(from), StandardCharsets.UTF_8);
                    break;
                }
                buffer.writeCharSequence((CharSequence)value.substring(from, to), StandardCharsets.UTF_8);
                buffer.writeByte(10);
                buffer.writeBytes(prefix);
                from = to + 1;
            }
            buffer.writeByte(10);
        }
    }
}

