/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBacking;
import ratpack.util.Types;

public class CachingBackedRegistry
implements Registry {
    private final RegistryBacking registryBacking;
    private final ConcurrentMap<TypeToken<?>, Iterable<? extends Supplier<?>>> supplierCache = new ConcurrentHashMap();

    public CachingBackedRegistry(RegistryBacking registryBacking) {
        this.registryBacking = registryBacking;
    }

    public <T> Optional<T> maybeGet(TypeToken<T> type) {
        Iterator<Supplier<T>> suppliers = this.getSuppliers(type).iterator();
        if (!suppliers.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(suppliers.next().get());
    }

    private static <K, V> V compute(Map<K, V> map, K key, Function<? super K, ? extends V> supplier) {
        V value = map.get(key);
        if (value == null) {
            value = supplier.apply(key);
            map.put(key, value);
        }
        return value;
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.transformToInstances(this.getSuppliers(type));
    }

    protected <O> Iterable<O> transformToInstances(Iterable<? extends Supplier<O>> suppliers) {
        return Iterables.transform(suppliers, s -> s.get());
    }

    protected <T> Iterable<? extends Supplier<T>> getSuppliers(TypeToken<T> type) {
        Iterable suppliers = CachingBackedRegistry.compute(this.supplierCache, type, t -> this.registryBacking.provide(type));
        return (Iterable)Types.cast(suppliers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingBackedRegistry that = (CachingBackedRegistry)o;
        return this.registryBacking.equals(that.registryBacking);
    }

    public int hashCode() {
        return this.registryBacking.hashCode();
    }
}

