/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.stream.TransformablePublisher;

public class FanOutPublisher<T>
implements TransformablePublisher<T> {
    private final Publisher<? extends Iterable<? extends T>> upstream;

    public FanOutPublisher(Publisher<? extends Iterable<? extends T>> upstream) {
        this.upstream = upstream;
    }

    public void subscribe(final Subscriber<? super T> downstream) {
        this.upstream.subscribe(new Subscriber<Iterable<? extends T>>(){
            private final AtomicBoolean done = new AtomicBoolean();

            public void onSubscribe(final Subscription subscription) {
                downstream.onSubscribe(new Subscription(){

                    public void request(long n) {
                        subscription.request(n);
                    }

                    public void cancel() {
                        done.set(true);
                        subscription.cancel();
                    }
                });
            }

            public void onNext(Iterable<? extends T> iterable) {
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext() && !this.done.get()) {
                    downstream.onNext(iterator.next());
                }
            }

            public void onError(Throwable t) {
                downstream.onError(t);
            }

            public void onComplete() {
                downstream.onComplete();
            }
        });
    }
}

