/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscription;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.stream.internal.BufferedWriteStream;
import ratpack.stream.internal.BufferingPublisher;

public class PeriodicPublisher<T>
extends BufferingPublisher<T> {
    public PeriodicPublisher(final ScheduledExecutorService executorService, final Function<? super Integer, ? extends T> producer, Duration duration) {
        super(Action.noop(), (? super BufferedWriteStream<T> write) -> new Subscription((BufferedWriteStream)write, duration){
            private final AtomicInteger counter = new AtomicInteger(0);
            private volatile ScheduledFuture future;
            final /* synthetic */ BufferedWriteStream val$write;
            final /* synthetic */ Duration val$cap$2;
            {
                this.val$write = bufferedWriteStream;
                this.val$cap$2 = duration;
            }

            public void request(long n) {
                if (this.future == null) {
                    this.future = executorService.scheduleWithFixedDelay(() -> {
                        Object value;
                        int i = this.counter.getAndIncrement();
                        try {
                            value = producer.apply(i);
                        }
                        catch (Exception e) {
                            this.val$write.error(e);
                            this.cancel();
                            return;
                        }
                        if (value == null) {
                            this.val$write.complete();
                            this.cancel();
                        } else {
                            this.val$write.item(value);
                        }
                    }, 0L, this.val$cap$2.toNanos(), TimeUnit.NANOSECONDS);
                }
            }

            public void cancel() {
                if (this.future != null) {
                    this.future.cancel(false);
                }
            }
        });
    }
}

