/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import io.netty.channel.EventLoop;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import ratpack.exec.Downstream;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.Result;
import ratpack.exec.internal.Continuation;
import ratpack.exec.internal.DefaultExecution;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.internal.ThreadBinding;
import ratpack.func.Block;
import ratpack.func.Factory;

public abstract class Blocking {
    private Blocking() {
    }

    public static <T> Promise<T> get(final Factory<T> factory) {
        return new DefaultPromise(downstream -> {
            final DefaultExecution execution = DefaultExecution.require();
            EventLoop eventLoop = execution.getEventLoop();
            execution.delimit(continuation -> eventLoop.execute(() -> CompletableFuture.supplyAsync(new Supplier<Result<T>>(){
                Result result;

                @Override
                public Result<T> get() {
                    try {
                        DefaultExecution.THREAD_BINDING.set((Object)execution);
                        Blocking.intercept(execution, execution.getAllInterceptors().iterator(), () -> {
                            try {
                                this.result = Result.success(factory.create());
                            }
                            catch (Throwable e) {
                                this.result = Result.error(e);
                            }
                        });
                        Result result = this.result;
                        return result;
                    }
                    catch (Throwable e) {
                        DefaultExecution.interceptorError(e);
                        Result result = this.result;
                        return result;
                    }
                    finally {
                        DefaultExecution.THREAD_BINDING.remove();
                    }
                }
            }, execution.getController().getBlockingExecutor()).thenAcceptAsync(v -> continuation.resume(() -> downstream.accept(v)), (Executor)eventLoop)));
        });
    }

    public static <T> T on(Promise<T> promise) throws Exception {
        ThreadBinding.requireBlockingThread("Blocking.on() can only be used while blocking (i.e. use Blocking.get() first)");
        DefaultExecution backing = DefaultExecution.require();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference resultReference = new AtomicReference();
        backing.delimit(continuation -> promise.connect(new Downstream<T>((Continuation)continuation, resultReference, latch){
            final /* synthetic */ Continuation val$continuation;
            final /* synthetic */ AtomicReference val$resultReference;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$continuation = continuation;
                this.val$resultReference = atomicReference;
                this.val$latch = countDownLatch;
            }

            @Override
            public void success(T value) {
                this.unlatch(Result.success(value));
            }

            @Override
            public void error(Throwable throwable) {
                this.unlatch(Result.error(throwable));
            }

            @Override
            public void complete() {
                this.unlatch(Result.success(null));
            }

            private void unlatch(Result<T> result) {
                this.val$continuation.resume(() -> {
                    this.val$resultReference.set(result);
                    this.val$latch.countDown();
                });
            }
        }));
        backing.eventLoopDrain();
        latch.await();
        return ((Result)resultReference.get()).getValueOrThrow();
    }

    public static Operation op(Block block) {
        return Blocking.get(() -> {
            block.execute();
            return null;
        }).operation();
    }

    public static void exec(Block block) {
        Blocking.op(block).then();
    }

    private static void intercept(Execution execution, Iterator<? extends ExecInterceptor> interceptors, Runnable runnable) throws Exception {
        if (interceptors.hasNext()) {
            interceptors.next().intercept(execution, ExecInterceptor.ExecType.BLOCKING, () -> Blocking.intercept(execution, interceptors, runnable));
        } else {
            runnable.run();
        }
    }
}

