/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.collect.ImmutableList;
import ratpack.file.BaseDirRequiredException;
import ratpack.file.FileHandlerSpec;
import ratpack.file.internal.FileHandler;
import ratpack.func.Action;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.server.ServerConfig;

public class DefaultFileHandlerSpec
implements FileHandlerSpec {
    private String path;
    private String dir;
    private ImmutableList<String> indexFiles = ImmutableList.of();

    @Override
    public FileHandlerSpec path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public FileHandlerSpec dir(String dir) {
        this.dir = dir;
        return this;
    }

    @Override
    public FileHandlerSpec indexFiles(String ... indexFiles) {
        this.indexFiles = ImmutableList.copyOf((Object[])indexFiles);
        return this;
    }

    public static Handler build(ServerConfig serverConfig, Action<? super FileHandlerSpec> config) throws Exception {
        if (!serverConfig.isHasBaseDir()) {
            throw new BaseDirRequiredException("no base dir set for application");
        }
        DefaultFileHandlerSpec spec = new DefaultFileHandlerSpec();
        config.execute(spec);
        Handler handler = new FileHandler(spec.indexFiles);
        if (spec.dir != null) {
            handler = Handlers.fileSystem(serverConfig, spec.dir, handler);
        }
        if (spec.path != null) {
            handler = Handlers.prefix(spec.path, handler);
        }
        return handler;
    }
}

