/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.Map;
import ratpack.func.Block;
import ratpack.handling.ByContentSpec;
import ratpack.handling.Handler;

public class DefaultByContentSpec
implements ByContentSpec {
    public static final String TYPE_PLAIN_TEXT = "text/plain";
    public static final String TYPE_HTML = "text/html";
    public static final String TYPE_JSON = "application/json";
    public static final String TYPE_XML = "application/xml";
    private final Map<String, Block> blocks;
    private Handler noMatchHandler = ctx -> ctx.clientError(406);

    public DefaultByContentSpec(Map<String, Block> blocks) {
        this.blocks = blocks;
    }

    @Override
    public ByContentSpec type(String mimeType, Block block) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        String trimmed = mimeType.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("mimeType cannot be a blank string");
        }
        if (trimmed.contains("*")) {
            throw new IllegalArgumentException("mimeType cannot include wildcards");
        }
        this.blocks.put(mimeType, block);
        return this;
    }

    @Override
    public ByContentSpec plainText(Block handler) {
        return this.type(TYPE_PLAIN_TEXT, handler);
    }

    @Override
    public ByContentSpec html(Block handler) {
        return this.type(TYPE_HTML, handler);
    }

    @Override
    public ByContentSpec json(Block handler) {
        return this.type(TYPE_JSON, handler);
    }

    @Override
    public ByContentSpec xml(Block handler) {
        return this.type(TYPE_XML, handler);
    }

    @Override
    public ByContentSpec noMatch(Block handler) {
        this.noMatchHandler = ctx -> handler.execute();
        return this;
    }

    @Override
    public ByContentSpec noMatch(String mimeType) {
        this.noMatchHandler = ctx -> {
            ctx.getResponse().contentType(mimeType);
            this.blocks.get(mimeType).execute();
        };
        return this;
    }

    public Handler getNoMatchHandler() {
        return this.noMatchHandler;
    }
}

