/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.ByContentSpec;
import ratpack.handling.ByMethodSpec;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Redirector;
import ratpack.handling.RequestId;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.ContentNegotiationHandler;
import ratpack.handling.internal.DefaultByContentSpec;
import ratpack.handling.internal.DefaultByMethodSpec;
import ratpack.handling.internal.HandlerException;
import ratpack.handling.internal.MultiMethodHandler;
import ratpack.handling.internal.ThrowableHolder;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.TypedData;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.parse.NoSuchParserException;
import ratpack.parse.Parse;
import ratpack.parse.Parser;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.path.internal.PathBindingStorage;
import ratpack.path.internal.RootPathBinding;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.TypeCaching;
import ratpack.render.NoSuchRendererException;
import ratpack.render.internal.RenderController;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;
import ratpack.util.Types;

public class DefaultContext
implements Context {
    private static final TypeToken<Parser<?>> PARSER_TYPE_TOKEN = TypeCaching.typeToken(new TypeToken<Parser<?>>(){});
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultContext.class);
    private final RequestConstants requestConstants;
    private Registry joinedRegistry;
    private PathBindingStorage pathBindings;

    public static Context current() {
        return Execution.current().get(Context.TYPE);
    }

    public static void start(EventLoop eventLoop, RequestConstants requestConstants, Registry registry, Handler[] handlers, Action<? super Execution> onComplete) {
        ChainIndex index = new ChainIndex(handlers, registry, true);
        requestConstants.indexes.push(index);
        DefaultContext context = new DefaultContext(requestConstants);
        requestConstants.context = context;
        context.pathBindings = new PathBindingStorage(new RootPathBinding(requestConstants.request.getPath()));
        requestConstants.applicationConstants.execController.fork().onError(throwable -> requestConstants.context.error(throwable instanceof HandlerException ? throwable.getCause() : throwable)).onComplete(onComplete).register(s -> s.add(Context.TYPE, context).add(Request.TYPE, requestConstants.request).add(Response.TYPE, requestConstants.response).add(PathBindingStorage.TYPE, context.pathBindings).addLazy(RequestId.TYPE, () -> registry.get(RequestId.Generator.TYPE).generate(requestConstants.request))).eventLoop(eventLoop).onStart(e -> DefaultRequest.setDelegateRegistry(requestConstants.request, e)).start(e -> {
            requestConstants.execution = e;
            context.joinedRegistry = new ContextRegistry(context).join(requestConstants.execution);
            context.next();
        });
    }

    public DefaultContext(RequestConstants requestConstants) {
        this.requestConstants = requestConstants;
    }

    private Registry getCurrentRegistry() {
        return ((ChainIndex)((RequestConstants)this.requestConstants).indexes.peek()).registry;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public Execution getExecution() {
        return this.requestConstants.execution;
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.requestConstants.applicationConstants.serverConfig;
    }

    @Override
    public Request getRequest() {
        return this.requestConstants.request;
    }

    @Override
    public Response getResponse() {
        return this.requestConstants.response;
    }

    @Override
    public void next() {
        Handler handler = null;
        ChainIndex index = (ChainIndex)this.requestConstants.indexes.peek();
        while (handler == null) {
            if (index.hasNext()) {
                handler = index.next();
                if (!handler.getClass().equals(ChainHandler.class)) continue;
                this.requestConstants.indexes.push(new ChainIndex(((ChainHandler)handler).getHandlers(), this.getCurrentRegistry(), false));
                index = (ChainIndex)this.requestConstants.indexes.peek();
                handler = null;
                continue;
            }
            if (index.first) {
                handler = this.requestConstants.applicationConstants.end;
                continue;
            }
            this.requestConstants.indexes.pop();
            index = (ChainIndex)this.requestConstants.indexes.peek();
        }
        try {
            this.requestConstants.handler = handler;
            handler.handle(this);
        }
        catch (Throwable e) {
            if (e instanceof HandlerException) {
                throw (HandlerException)e;
            }
            throw new HandlerException(e);
        }
    }

    @Override
    public void next(Registry registry) {
        ((ChainIndex)((RequestConstants)this.requestConstants).indexes.peek()).registry = this.getCurrentRegistry().join(registry);
        this.next();
    }

    @Override
    public void insert(Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.requestConstants.indexes.push(new ChainIndex(handlers, this.getCurrentRegistry(), false));
        this.next();
    }

    @Override
    public void insert(Registry registry, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.requestConstants.indexes.push(new ChainIndex(handlers, this.getCurrentRegistry().join(registry), false));
        this.next();
    }

    @Override
    public PathTokens getPathTokens() {
        return ((PathBinding)this.pathBindings.peek()).getTokens();
    }

    @Override
    public PathTokens getAllPathTokens() {
        return ((PathBinding)this.pathBindings.peek()).getAllTokens();
    }

    @Override
    public Path file(String path) {
        return this.get(FileSystemBinding.TYPE).file(path);
    }

    @Override
    public void render(Object object) throws NoSuchRendererException {
        try {
            this.requestConstants.applicationConstants.renderController.render(object, this);
        }
        catch (NoSuchRendererException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public <T, O> Promise<T> parse(Parse<T, O> parse) {
        return this.getRequest().getBody().map(b -> this.parse((TypedData)b, parse));
    }

    @Override
    public <T, O> T parse(TypedData body, Parse<T, O> parse) throws Exception {
        ArrayList parsers = Lists.newArrayList();
        Function<Parser, Object> parserPredicate = parse.getOpts().isPresent() ? parser -> {
            if (parser.getOptsType().isInstance(parse.getOpts().get())) {
                parsers.add(parser);
                Parser cast = (Parser)Types.cast(parser);
                return cast.parse(this, body, parse);
            }
            return null;
        } : parser -> {
            parsers.add(parser);
            Parser cast = (Parser)Types.cast(parser);
            return cast.parse(this, body, parse);
        };
        return (T)this.joinedRegistry.first(PARSER_TYPE_TOKEN, parserPredicate).orElseThrow(() -> new NoSuchParserException(parse.getType(), parse.getOpts().orElse(null), body.getContentType().getType(), parsers));
    }

    @Override
    public <T> Promise<T> parse(Class<T> type) {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T> Promise<T> parse(TypeToken<T> type) {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T, O> Promise<T> parse(Class<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public <T, O> Promise<T> parse(TypeToken<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public void onClose(Action<? super RequestOutcome> callback) {
        this.requestConstants.responseTransmitter.addOutcomeListener(callback);
    }

    @Override
    public DirectChannelAccess getDirectChannelAccess() {
        return this.requestConstants;
    }

    @Override
    public void redirect(String location) {
        this.redirect(HttpResponseStatus.FOUND.code(), location);
    }

    @Override
    public void redirect(int code, String location) {
        Redirector redirector = this.joinedRegistry.get(Redirector.TYPE);
        redirector.redirect(this, location, code);
    }

    @Override
    public void lastModified(Date date, Runnable runnable) {
        long time;
        long ifModifiedSinceSecs;
        Date ifModifiedSinceHeader = this.requestConstants.request.getHeaders().getDate((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        long lastModifiedSecs = date.getTime() / 1000L;
        if (ifModifiedSinceHeader != null && lastModifiedSecs == (ifModifiedSinceSecs = (time = ifModifiedSinceHeader.getTime()) / 1000L)) {
            this.requestConstants.response.status(HttpResponseStatus.NOT_MODIFIED.code()).send();
            return;
        }
        this.requestConstants.response.getHeaders().setDate(HttpHeaderConstants.LAST_MODIFIED, date);
        runnable.run();
    }

    @Override
    public void error(Throwable throwable) {
        ServerErrorHandler serverErrorHandler = this.get(ServerErrorHandler.TYPE);
        throwable = this.unpackThrowable(throwable);
        ThrowableHolder throwableHolder = this.getRequest().maybeGet(ThrowableHolder.TYPE).orElse(null);
        if (throwableHolder == null) {
            this.getRequest().add((TypeToken)ThrowableHolder.TYPE, (Object)new ThrowableHolder(throwable));
            try {
                serverErrorHandler.error(this, throwable);
            }
            catch (Throwable errorHandlerThrowable) {
                this.onErrorHandlerError(serverErrorHandler, throwable, errorHandlerThrowable);
            }
        } else {
            this.onErrorHandlerError(serverErrorHandler, throwableHolder.getThrowable(), throwable);
        }
    }

    private void onErrorHandlerError(ServerErrorHandler serverErrorHandler, Throwable original, Throwable errorHandlerThrowable) {
        String msg = "Throwable thrown by error handler " + serverErrorHandler + " while handling throwable\n" + "Original throwable: " + Throwables.getStackTraceAsString((Throwable)original) + "\n" + "Error handler throwable: " + Throwables.getStackTraceAsString((Throwable)errorHandlerThrowable);
        LOGGER.error(msg);
        Response response = this.requestConstants.response.status(500);
        if (this.getServerConfig().isDevelopment()) {
            response.send(msg);
        } else {
            response.send();
        }
    }

    private Throwable unpackThrowable(Throwable throwable) {
        if (throwable instanceof UndeclaredThrowableException) {
            return throwable.getCause();
        }
        return throwable;
    }

    @Override
    public void clientError(int statusCode) {
        try {
            this.get(ClientErrorHandler.TYPE).error(this, statusCode);
        }
        catch (Throwable e) {
            this.error(Exceptions.toException(e));
        }
    }

    @Override
    public void byMethod(Action<? super ByMethodSpec> action) throws Exception {
        LinkedHashMap blocks = Maps.newLinkedHashMap();
        DefaultByMethodSpec spec = new DefaultByMethodSpec(blocks);
        action.execute(spec);
        new MultiMethodHandler(blocks).handle(this);
    }

    @Override
    public void byContent(Action<? super ByContentSpec> action) throws Exception {
        LinkedHashMap blocks = Maps.newLinkedHashMap();
        DefaultByContentSpec spec = new DefaultByContentSpec(blocks);
        action.execute(spec);
        new ContentNegotiationHandler(blocks, spec.getNoMatchHandler()).handle(this);
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        if (type.equals(PathBinding.TYPE)) {
            return (O)Types.cast(this.pathBindings.peek());
        }
        return this.joinedRegistry.get(type);
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        return this.joinedRegistry.maybeGet(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.joinedRegistry.getAll(type);
    }

    @Override
    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        return this.joinedRegistry.first(type, function);
    }

    private static class ContextRegistry
    implements Registry {
        private final DefaultContext context;

        public ContextRegistry(DefaultContext context) {
            this.context = context;
        }

        @Override
        public <O> Optional<O> maybeGet(TypeToken<O> type) {
            return this.context.getCurrentRegistry().maybeGet(type);
        }

        @Override
        public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
            return this.context.getCurrentRegistry().getAll(type);
        }
    }

    private static class ChainIndex
    implements Iterator<Handler> {
        final Handler[] handlers;
        Registry registry;
        final boolean first;
        int i;

        private ChainIndex(Handler[] handlers, Registry registry, boolean first) {
            this.handlers = handlers;
            this.registry = registry;
            this.first = first;
        }

        @Override
        public Handler next() {
            return this.handlers[this.i++];
        }

        @Override
        public boolean hasNext() {
            return this.i < this.handlers.length;
        }
    }

    public static class RequestConstants
    implements DirectChannelAccess {
        private final ApplicationConstants applicationConstants;
        private final DefaultRequest request;
        private final Channel channel;
        private final ResponseTransmitter responseTransmitter;
        private final Action<Action<Object>> onTakeOwnership;
        private Execution execution;
        private final Deque<ChainIndex> indexes = new ArrayDeque<ChainIndex>();
        public Response response;
        public Context context;
        public Handler handler;

        public RequestConstants(ApplicationConstants applicationConstants, DefaultRequest request, Channel channel, ResponseTransmitter responseTransmitter, Action<Action<Object>> onTakeOwnership) {
            this.applicationConstants = applicationConstants;
            this.request = request;
            this.channel = channel;
            this.responseTransmitter = responseTransmitter;
            this.onTakeOwnership = onTakeOwnership;
        }

        @Override
        public Channel getChannel() {
            return this.channel;
        }

        @Override
        public void takeOwnership(Action<Object> messageReceiver) {
            try {
                this.onTakeOwnership.execute(messageReceiver);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        }
    }

    public static class ApplicationConstants {
        private final RenderController renderController;
        private final ExecController execController;
        private final ServerConfig serverConfig;
        private final Handler end;

        public ApplicationConstants(Registry registry, RenderController renderController, ExecController execController, Handler end) {
            this.renderController = renderController;
            this.execController = execController;
            this.serverConfig = registry.get(ServerConfig.TYPE);
            this.end = end;
        }
    }
}

