/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import ratpack.exec.Downstream;
import ratpack.exec.Promise;
import ratpack.func.Block;
import ratpack.http.RequestBodyAlreadyReadException;
import ratpack.http.RequestBodyTooLargeException;
import ratpack.server.internal.DefaultResponseTransmitter;
import ratpack.server.internal.RequestBodyAccumulator;
import ratpack.server.internal.RequestBodyReader;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.internal.BufferedWriteStream;
import ratpack.stream.internal.BufferingPublisher;

public class RequestBody
implements RequestBodyReader,
RequestBodyAccumulator {
    private final List<ByteBuf> byteBufs = new ArrayList<ByteBuf>();
    private final long advertisedLength;
    private final HttpRequest request;
    private final ChannelHandlerContext ctx;
    private boolean read;
    private boolean done;
    private long maxContentLength = -1L;
    private Block onTooLarge;
    private long length;
    private Downstream<? super ByteBuf> downstream;
    private ByteBuf compositeBuffer;
    private Consumer<? super HttpContent> onAdd;

    public RequestBody(long advertisedLength, HttpRequest request, ChannelHandlerContext ctx) {
        this.advertisedLength = advertisedLength;
        this.request = request;
        this.ctx = ctx;
    }

    @Override
    public void add(HttpContent httpContent) {
        if (this.onAdd == null) {
            if (httpContent != LastHttpContent.EMPTY_LAST_CONTENT) {
                ByteBuf byteBuf = httpContent.content();
                this.length += (long)byteBuf.readableBytes();
                if (this.maxContentLength > 0L && this.maxContentLength < this.length) {
                    assert (this.downstream != null);
                    this.tooLarge(this.downstream);
                    return;
                }
                this.byteBufs.add(byteBuf);
            }
            if (httpContent instanceof LastHttpContent) {
                this.done = true;
                if (this.downstream != null) {
                    this.complete(this.downstream);
                }
            } else if (this.downstream != null) {
                this.ctx.read();
            }
        } else {
            this.onAdd.accept((HttpContent)httpContent);
        }
    }

    @Override
    public boolean isComplete() {
        return this.done;
    }

    @Override
    public void close() {
        if (this.compositeBuffer == null) {
            for (ByteBuf byteBuf : this.byteBufs) {
                byteBuf.release();
            }
            this.byteBufs.clear();
        } else if (this.compositeBuffer.refCnt() > 0) {
            this.compositeBuffer.release();
        }
    }

    public void forceCloseConnection() {
        this.close();
        ((DefaultResponseTransmitter)this.ctx.attr(DefaultResponseTransmitter.ATTRIBUTE_KEY).get()).forceCloseConnection();
    }

    private void tooLarge(Downstream<? super ByteBuf> downstream) {
        this.forceCloseConnection();
        try {
            this.onTooLarge.execute();
            downstream.complete();
        }
        catch (Throwable t) {
            downstream.error(t);
        }
    }

    private void complete(Downstream<? super ByteBuf> downstream) {
        if (this.byteBufs.isEmpty()) {
            downstream.success((ByteBuf)Unpooled.EMPTY_BUFFER);
        } else {
            this.compositeBuffer = this.composeReceived();
            downstream.success((ByteBuf)this.compositeBuffer);
        }
    }

    private ByteBuf composeReceived() {
        if (this.byteBufs.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf[] byteBufsArray = this.byteBufs.toArray(new ByteBuf[this.byteBufs.size()]);
        this.byteBufs.clear();
        return Unpooled.unmodifiableBuffer((ByteBuf[])byteBufsArray);
    }

    @Override
    public TransformablePublisher<? extends ByteBuf> readStream(long maxContentLength) {
        return Streams.bindExec(new BufferingPublisher<ByteBuf>(ReferenceCounted::release, write -> {
            if (this.read) {
                throw new RequestBodyAlreadyReadException();
            }
            this.read = true;
            this.maxContentLength = maxContentLength;
            if (this.advertisedLength > maxContentLength || this.length > maxContentLength) {
                this.forceCloseConnection();
                throw new RequestBodyTooLargeException(maxContentLength, Math.max(this.advertisedLength, this.length));
            }
            this.ctx.channel().config().setAutoRead(false);
            return new Subscription((BufferedWriteStream)write, maxContentLength){
                boolean autoRead;
                final /* synthetic */ BufferedWriteStream val$write;
                final /* synthetic */ long val$maxContentLength;
                {
                    this.val$write = bufferedWriteStream;
                    this.val$maxContentLength = l;
                }

                public void request(long n) {
                    if (RequestBody.this.onAdd == null) {
                        ByteBuf alreadyReceived = RequestBody.this.composeReceived();
                        if (alreadyReceived.readableBytes() > 0) {
                            this.val$write.item(alreadyReceived);
                        }
                        if (RequestBody.this.done) {
                            this.val$write.complete();
                            return;
                        }
                        RequestBody.this.onAdd = httpContent -> {
                            if (httpContent != LastHttpContent.EMPTY_LAST_CONTENT) {
                                ByteBuf byteBuf = httpContent.content();
                                RequestBody.this.length = RequestBody.this.length + (long)byteBuf.readableBytes();
                                if (this.val$maxContentLength > 0L && this.val$maxContentLength < RequestBody.this.length) {
                                    RequestBody.this.forceCloseConnection();
                                    this.val$write.error(new RequestBodyTooLargeException(this.val$maxContentLength, RequestBody.this.length));
                                    return;
                                }
                                this.val$write.item(byteBuf);
                            }
                            if (httpContent instanceof LastHttpContent) {
                                RequestBody.this.done = true;
                                RequestBody.this.ctx.channel().config().setAutoRead(false);
                                this.val$write.complete();
                            } else if (!this.autoRead && this.val$write.getRequested() > 0L) {
                                RequestBody.this.ctx.channel().read();
                            }
                        };
                    }
                    if (n == Long.MAX_VALUE) {
                        RequestBody.this.ctx.channel().config().setAutoRead(true);
                        this.autoRead = true;
                    } else {
                        RequestBody.this.ctx.channel().read();
                    }
                }

                public void cancel() {
                    RequestBody.this.forceCloseConnection();
                }
            };
        }));
    }

    @Override
    public long getContentLength() {
        return this.advertisedLength;
    }

    public Promise<ByteBuf> read(long maxContentLength, Block onTooLarge) {
        return Promise.of(downstream -> {
            if (this.read) {
                downstream.error(new RequestBodyAlreadyReadException());
                return;
            }
            this.read = true;
            this.onTooLarge = onTooLarge;
            if (this.advertisedLength > maxContentLength || this.length > maxContentLength) {
                this.tooLarge(downstream);
            } else if (this.done) {
                this.complete(downstream);
            } else {
                this.maxContentLength = maxContentLength;
                this.downstream = downstream;
                if (HttpUtil.is100ContinueExpected((HttpMessage)this.request)) {
                    DefaultFullHttpResponse continueResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
                    this.ctx.writeAndFlush((Object)continueResponse).addListener(future -> {
                        if (!future.isSuccess()) {
                            this.ctx.fireExceptionCaught(future.cause());
                        }
                    });
                }
                this.ctx.read();
            }
        });
    }
}

