/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import ratpack.config.ConfigSource;
import ratpack.file.FileSystemBinding;
import ratpack.util.Exceptions;

public class ConfigDataLoader {
    private final ObjectMapper objectMapper;
    private final Iterable<ConfigSource> configSources;
    private final FileSystemBinding fileSystemBinding;

    public ConfigDataLoader(ObjectMapper objectMapper, Iterable<ConfigSource> configSources, FileSystemBinding fileSystemBinding) {
        this.objectMapper = objectMapper;
        this.configSources = configSources;
        this.fileSystemBinding = fileSystemBinding;
    }

    public ObjectNode load() {
        ObjectNode node = this.objectMapper.createObjectNode();
        try {
            for (ConfigSource source : this.configSources) {
                this.merge((JsonNode)source.loadConfigData(this.objectMapper, this.fileSystemBinding), (JsonNode)node);
            }
        }
        catch (Exception ex) {
            throw Exceptions.uncheck(ex);
        }
        return node;
    }

    private void merge(JsonNode sourceNode, JsonNode destNode) {
        Iterator fieldNames = sourceNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode sourceFieldValue = sourceNode.get(fieldName);
            JsonNode destFieldValue = destNode.get(fieldName);
            if (destFieldValue != null && destFieldValue.isObject()) {
                this.merge(sourceFieldValue, destFieldValue);
                continue;
            }
            if (!(destNode instanceof ObjectNode)) continue;
            ((ObjectNode)destNode).replace(fieldName, sourceFieldValue);
        }
    }
}

