/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import java.time.Duration;
import java.util.Objects;
import ratpack.api.NonBlocking;
import ratpack.exec.Blocking;
import ratpack.exec.Downstream;
import ratpack.exec.Operation;
import ratpack.exec.Result;
import ratpack.exec.Throttle;
import ratpack.exec.Upstream;
import ratpack.exec.internal.CachingUpstream;
import ratpack.exec.internal.DefaultExecution;
import ratpack.exec.internal.DefaultOperation;
import ratpack.exec.internal.DefaultPromise;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.func.Pair;
import ratpack.func.Predicate;

public interface Promise<T> {
    public static <T> Promise<T> async(Upstream<T> upstream) {
        return new DefaultPromise<T>(DefaultExecution.upstream(upstream));
    }

    public static <T> Promise<T> sync(Factory<T> factory) {
        return Promise.async(down -> {
            Object t;
            try {
                t = factory.create();
            }
            catch (Exception e) {
                down.error(e);
                return;
            }
            down.success(t);
        });
    }

    public static <T> Promise<T> value(T t) {
        return Promise.async(down -> down.success(t));
    }

    public static <T> Promise<T> error(Throwable t) {
        return Promise.async(down -> down.error(t));
    }

    @Deprecated
    public static <T> Promise<T> of(Upstream<T> upstream) {
        return Promise.async(upstream);
    }

    @Deprecated
    public static <T> Promise<T> ofLazy(Factory<T> factory) {
        return Promise.sync(factory);
    }

    public void then(Action<? super T> var1);

    public void connect(Downstream<? super T> var1);

    public <O> Promise<O> transform(Function<? super Upstream<? extends T>, ? extends Upstream<O>> var1);

    default public Promise<T> onError(Predicate<? super Throwable> predicate, Action<? super Throwable> errorHandler) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (predicate.apply((Throwable)throwable)) {
                try {
                    errorHandler.execute((Throwable)throwable);
                }
                catch (Throwable e) {
                    if (e != throwable) {
                        e.addSuppressed((Throwable)throwable);
                    }
                    down.error(e);
                    return;
                }
                down.complete();
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public <E extends Throwable> Promise<T> onError(Class<E> errorType, Action<? super E> errorHandler) {
        return this.onError(errorType::isInstance, (? super Throwable t) -> errorHandler.execute((Object)errorType.cast(t)));
    }

    default public Promise<T> onError(Action<? super Throwable> errorHandler) {
        return this.onError(Predicate.TRUE, errorHandler);
    }

    default public void result(Action<? super Result<T>> resultHandler) {
        this.onError(t -> resultHandler.execute(Result.error(t))).then(v -> resultHandler.execute(Result.success(v)));
    }

    default public <O> Promise<O> map(Function<? super T, ? extends O> transformer) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            try {
                Object apply = transformer.apply((Object)value);
                down.success(apply);
            }
            catch (Throwable e) {
                down.error(e);
            }
        })));
    }

    default public <O> Promise<O> blockingMap(Function<? super T, ? extends O> transformer) {
        return this.flatMap(t -> Blocking.get(() -> transformer.apply((Object)t)));
    }

    default public Promise<T> blockingOp(Action<? super T> action) {
        return this.flatMap(t -> Blocking.op(action.curry(t)).map(() -> t));
    }

    @Deprecated
    default public <O> Promise<O> next(Promise<O> next) {
        return this.flatMap(in -> next);
    }

    default public Promise<T> next(@NonBlocking Action<? super T> action) {
        return this.nextOp(v -> Operation.of(() -> action.execute(v)));
    }

    default public Promise<T> nextOp(Function<? super T, ? extends Operation> function) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> ((Operation)function.apply((Object)value)).onError(down::error).then(() -> down.success(value)))));
    }

    default public <O> Promise<O> replace(Promise<O> next) {
        return this.flatMap(in -> next);
    }

    default public <O> Promise<Pair<O, T>> left(Promise<O> left) {
        return this.flatMap(right -> left.map(value -> Pair.of(value, right)));
    }

    default public <O> Promise<Pair<T, O>> right(Promise<O> right) {
        return this.flatMap(left -> right.map(value -> Pair.of(left, value)));
    }

    default public Operation operation() {
        return this.operation(Action.noop());
    }

    default public Operation operation(Action<? super T> action) {
        return new DefaultOperation(this.map(t -> {
            action.execute(t);
            return null;
        }));
    }

    default public Promise<T> mapError(Function<? super Throwable, ? extends T> transformer) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            try {
                Object transformed = transformer.apply((Throwable)throwable);
                down.success(transformed);
            }
            catch (Throwable t) {
                down.error(t);
            }
        })));
    }

    default public <E extends Throwable> Promise<T> mapError(Class<E> type, Function<? super Throwable, ? extends T> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (type.isInstance(throwable)) {
                Object transformed;
                try {
                    transformed = function.apply((Throwable)throwable);
                }
                catch (Throwable t) {
                    down.error(t);
                    return;
                }
                down.success(transformed);
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public Promise<T> flatMapError(Function<? super Throwable, ? extends Promise<T>> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            Promise transformed;
            try {
                transformed = (Promise)function.apply((Throwable)throwable);
            }
            catch (Throwable t) {
                down.error(t);
                return;
            }
            transformed.connect(down);
        })));
    }

    default public <E extends Throwable> Promise<T> flatMapError(Class<E> type, Function<? super E, ? extends Promise<T>> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (type.isInstance(throwable)) {
                Promise transformed;
                try {
                    transformed = (Promise)function.apply((Object)type.cast(throwable));
                }
                catch (Throwable t) {
                    down.error(t);
                    return;
                }
                transformed.connect(down);
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public <O> Promise<O> apply(Function<? super Promise<T>, ? extends Promise<O>> function) {
        try {
            return function.apply(this);
        }
        catch (Throwable e) {
            return Promise.error(e);
        }
    }

    default public <O> O to(Function<? super Promise<T>, ? extends O> function) throws Exception {
        return function.apply(this);
    }

    default public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            try {
                ((Promise)transformer.apply((Object)value)).onError(down::error).then(down::success);
            }
            catch (Throwable e) {
                down.error(e);
            }
        })));
    }

    default public Promise<T> route(Predicate<? super T> predicate, Action<? super T> action) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            boolean apply;
            try {
                apply = predicate.apply(value);
            }
            catch (Throwable e) {
                down.error(e);
                return;
            }
            if (apply) {
                try {
                    action.execute(value);
                    down.complete();
                }
                catch (Throwable e) {
                    down.error(e);
                }
            } else {
                down.success(value);
            }
        })));
    }

    default public Promise<T> onNull(Block action) {
        return this.route(Objects::isNull, Action.ignoreArg(action));
    }

    default public Promise<T> cache() {
        return this.transform(CachingUpstream::new);
    }

    default public Promise<T> defer(Action<? super Runnable> releaser) {
        return this.transform(up -> down -> Promise.async(innerDown -> releaser.execute(() -> innerDown.success(true))).then(v -> up.connect(down)));
    }

    default public Promise<T> onYield(Runnable onYield) {
        return this.transform(up -> down -> {
            try {
                onYield.run();
            }
            catch (Throwable e) {
                down.error(e);
                return;
            }
            up.connect(down);
        });
    }

    default public Promise<T> wiretap(final Action<? super Result<T>> listener) {
        return this.transform(up -> down -> up.connect(new Downstream<T>(){

            @Override
            public void success(T value) {
                try {
                    listener.execute(Result.success(value));
                }
                catch (Exception e) {
                    down.error(e);
                    return;
                }
                down.success(value);
            }

            @Override
            public void error(Throwable throwable) {
                try {
                    listener.execute(Result.error(throwable));
                }
                catch (Exception e) {
                    throwable.addSuppressed(e);
                }
                down.error(throwable);
            }

            @Override
            public void complete() {
                down.complete();
            }
        }));
    }

    default public Promise<T> throttled(Throttle throttle) {
        return throttle.throttle(this);
    }

    default public Promise<T> close(final AutoCloseable closeable) {
        return this.transform(up -> down -> up.connect(new Downstream<T>(){

            @Override
            public void success(T value) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    down.error(e);
                    return;
                }
                down.success(value);
            }

            @Override
            public void error(Throwable throwable) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    throwable.addSuppressed(e);
                }
                down.error(throwable);
            }

            @Override
            public void complete() {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    down.error(e);
                    return;
                }
                down.complete();
            }
        }));
    }

    default public Promise<T> time(final Action<? super Duration> action) {
        return this.transform(up -> down -> {
            final long start = System.nanoTime();
            up.connect(new Downstream<T>(){

                private Duration duration() {
                    return Duration.ofNanos(Math.max(0L, System.nanoTime() - start));
                }

                @Override
                public void success(T value) {
                    try {
                        action.execute(this.duration());
                    }
                    catch (Throwable t) {
                        down.error(t);
                        return;
                    }
                    down.success(value);
                }

                @Override
                public void error(Throwable throwable) {
                    try {
                        action.execute(this.duration());
                    }
                    catch (Throwable t) {
                        throwable.addSuppressed(t);
                    }
                    down.error(throwable);
                }

                @Override
                public void complete() {
                    try {
                        action.execute(this.duration());
                    }
                    catch (Throwable t) {
                        down.error(t);
                        return;
                    }
                    down.complete();
                }
            });
        });
    }

    public static <T> Promise<T> wrap(Factory<? extends Promise<T>> factory) {
        try {
            return factory.create();
        }
        catch (Exception e) {
            return Promise.error(e);
        }
    }
}

