/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import ratpack.handling.Context;
import ratpack.health.HealthCheck;
import ratpack.health.HealthCheckResults;
import ratpack.render.RendererSupport;

public class HealthCheckResultsRenderer
extends RendererSupport<HealthCheckResults> {
    private final ByteBufAllocator byteBufAllocator;

    public HealthCheckResultsRenderer(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
    }

    @Override
    public void render(Context context, HealthCheckResults healthCheckResults) throws Exception {
        ByteBuf buffer = this.byteBufAllocator.buffer();
        boolean first = true;
        boolean unhealthy = false;
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream((OutputStream)new ByteBufOutputStream(buffer)));
            for (Map.Entry entry : healthCheckResults.getResults().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    writer.write("\n");
                }
                String name = (String)entry.getKey();
                HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
                ((Writer)writer).append(name).append(" : ").append(result.isHealthy() ? "HEALTHY" : "UNHEALTHY");
                if (result.isHealthy()) continue;
                unhealthy = true;
                ((Writer)writer).append(" [").append(result.getMessage()).append("]");
                if (result.getError() == null) continue;
                ((Writer)writer).append(" [").append(result.getError().toString()).append("]");
            }
            ((Writer)writer).close();
        }
        catch (Exception e) {
            buffer.release();
            throw e;
        }
        context.getResponse().status(unhealthy ? 503 : 200).send(buffer);
    }
}

