/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.path.internal.DefaultPathTokens;

public class DefaultPathBinding
implements PathBinding {
    private final String binding;
    private final String pastBinding;
    private final PathTokens tokens;
    private final PathTokens allTokens;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPathBinding that = (DefaultPathBinding)o;
        return this.binding.equals(that.binding) && this.pastBinding.equals(that.pastBinding) && this.allTokens.equals(that.allTokens);
    }

    public int hashCode() {
        int result = this.binding.hashCode();
        result = 31 * result + this.pastBinding.hashCode();
        result = 31 * result + this.allTokens.hashCode();
        return result;
    }

    public DefaultPathBinding(String binding, ImmutableMap<String, String> tokens, PathBinding parent) {
        this.binding = binding;
        this.tokens = DefaultPathTokens.of(tokens);
        this.allTokens = parent.getAllTokens().isEmpty() ? this.tokens : DefaultPathTokens.of((ImmutableMap<String, String>)ImmutableMap.builder().putAll((Map)parent.getAllTokens()).putAll(tokens).build());
        String bindingWithSlash = binding.concat("/");
        String path = parent.getPastBinding();
        if (path.equals(binding)) {
            this.pastBinding = "";
        } else if (path.startsWith(bindingWithSlash)) {
            this.pastBinding = path.substring(bindingWithSlash.length());
        } else {
            throw new IllegalArgumentException(String.format("Path '%s' is not a child of '%s'", path, binding));
        }
    }

    @Override
    public String getPastBinding() {
        return this.pastBinding;
    }

    @Override
    public String getBoundTo() {
        return this.binding;
    }

    @Override
    public PathTokens getTokens() {
        return this.tokens;
    }

    @Override
    public PathTokens getAllTokens() {
        return this.allTokens;
    }
}

