/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.net.URISyntaxException;
import ratpack.exec.Execution;
import ratpack.http.Headers;
import ratpack.http.Request;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.server.PublicAddress;
import ratpack.util.Exceptions;
import ratpack.util.internal.ProtocolUtil;

public class InferringPublicAddress
implements PublicAddress {
    private static final Splitter FORWARDED_HOST_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final String defaultScheme;

    public InferringPublicAddress(String defaultScheme) {
        this.defaultScheme = defaultScheme;
    }

    @Override
    public URI get() {
        int port;
        String host;
        Request request = Execution.current().maybeGet(Request.class).orElseThrow(() -> new IllegalStateException("Inferring the public address is only supported during a request execution."));
        String scheme = this.determineScheme(request);
        HostAndPort forwardedHostData = this.getForwardedHostData(request);
        if (forwardedHostData != null) {
            host = forwardedHostData.getHostText();
            port = forwardedHostData.getPortOrDefault(-1);
        } else {
            URI absoluteRequestURI = this.getAbsoluteRequestUri(request);
            if (absoluteRequestURI != null) {
                host = absoluteRequestURI.getHost();
                port = absoluteRequestURI.getPort();
            } else {
                HostAndPort hostData = this.getHostData(request);
                if (hostData != null) {
                    host = hostData.getHostText();
                    port = hostData.getPortOrDefault(-1);
                } else {
                    HostAndPort localAddress = request.getLocalAddress();
                    host = localAddress.getHostText();
                    port = ProtocolUtil.isDefaultPortForScheme(localAddress.getPort(), scheme) ? -1 : localAddress.getPort();
                }
            }
        }
        try {
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException ex) {
            throw Exceptions.uncheck(ex);
        }
    }

    private URI getAbsoluteRequestUri(Request request) {
        String rawUri = Strings.nullToEmpty((String)request.getRawUri());
        if (rawUri.isEmpty() || rawUri.startsWith("/")) {
            return null;
        }
        return URI.create(rawUri);
    }

    private HostAndPort getForwardedHostData(Request request) {
        Headers headers = request.getHeaders();
        String forwardedHostHeader = Strings.emptyToNull((String)headers.get(HttpHeaderConstants.X_FORWARDED_HOST.toString()));
        String hostPortString = forwardedHostHeader != null ? (String)Iterables.getFirst((Iterable)FORWARDED_HOST_SPLITTER.split((CharSequence)forwardedHostHeader), null) : null;
        return hostPortString != null ? HostAndPort.fromString((String)hostPortString) : null;
    }

    private HostAndPort getHostData(Request request) {
        Headers headers = request.getHeaders();
        String hostPortString = Strings.emptyToNull((String)headers.get(HttpHeaderConstants.HOST.toString()));
        return hostPortString != null ? HostAndPort.fromString((String)hostPortString) : null;
    }

    private String determineScheme(Request request) {
        Headers headers = request.getHeaders();
        String forwardedSsl = headers.get(HttpHeaderConstants.X_FORWARDED_SSL.toString());
        String forwardedProto = headers.get(HttpHeaderConstants.X_FORWARDED_PROTO.toString());
        if (HttpHeaderConstants.ON.toString().equalsIgnoreCase(forwardedSsl)) {
            return "https";
        }
        return forwardedProto != null ? forwardedProto : this.defaultScheme;
    }
}

