/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ratpack.file.internal.FileSystemChecksumService;

public class CachingFileSystemChecksumService
implements FileSystemChecksumService {
    private final FileSystemChecksumService delegate;
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    public CachingFileSystemChecksumService(FileSystemChecksumService delegate) {
        this.delegate = delegate;
    }

    @Override
    public String checksum(String path) throws Exception {
        if (path == null) {
            return null;
        }
        String checksum = (String)this.cache.get(path);
        if (checksum == null) {
            checksum = this.delegate.checksum(path);
            this.cache.put(path, checksum);
        }
        return checksum;
    }
}

