/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.reflect.TypeToken;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.ResourceLeakDetector;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.Blocking;
import ratpack.exec.Promise;
import ratpack.exec.Throttle;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.impose.Impositions;
import ratpack.impose.UserRegistryImposition;
import ratpack.registry.Registry;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ReloadInformant;
import ratpack.server.ServerConfig;
import ratpack.server.internal.HostUtil;
import ratpack.server.internal.IgnorableHttpContentCompressor;
import ratpack.server.internal.NettyHandlerAdapter;
import ratpack.server.internal.RatpackServerDefinition;
import ratpack.server.internal.ServerCapturer;
import ratpack.server.internal.ServerRegistry;
import ratpack.server.internal.Slf4jNoBindingDetector;
import ratpack.service.internal.DefaultEvent;
import ratpack.service.internal.ServicesGraph;
import ratpack.util.Exceptions;
import ratpack.util.Types;
import ratpack.util.internal.ChannelImplDetector;

public class DefaultRatpackServer
implements RatpackServer {
    public static final TypeToken<ReloadInformant> RELOAD_INFORMANT_TYPE = Types.token(ReloadInformant.class);
    public static final TypeToken<HandlerDecorator> HANDLER_DECORATOR_TYPE_TOKEN;
    public static final Logger LOGGER;
    protected final Action<? super RatpackServerSpec> definitionFactory;
    protected InetSocketAddress boundAddress;
    protected Channel channel;
    protected DefaultExecController execController;
    protected Registry serverRegistry = Registry.empty();
    protected ServicesGraph servicesGraph;
    protected boolean reloading;
    protected final AtomicBoolean needsReload = new AtomicBoolean();
    protected boolean useSsl;
    private final Impositions impositions;
    private Thread shutdownHookThread;

    public DefaultRatpackServer(Action<? super RatpackServerSpec> definitionFactory, Impositions impositions) throws Exception {
        this.definitionFactory = definitionFactory;
        this.impositions = impositions;
        ServerCapturer.capture(this);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isRunning()) {
            return;
        }
        LOGGER.info("Starting server...");
        DefinitionBuild definitionBuild = this.buildUserDefinition();
        if (definitionBuild.error != null) {
            if (definitionBuild.getServerConfig().isDevelopment()) {
                LOGGER.warn("Exception raised getting server config (will use default config until reload):", definitionBuild.error);
                this.needsReload.set(true);
            } else {
                throw Exceptions.toException(definitionBuild.error);
            }
        }
        ServerConfig serverConfig = definitionBuild.getServerConfig();
        this.execController = new DefaultExecController(serverConfig.getThreads());
        ChannelHandler channelHandler = this.buildHandler(definitionBuild);
        this.channel = this.buildChannel(serverConfig, channelHandler);
        this.boundAddress = (InetSocketAddress)this.channel.localAddress();
        String startMessage = String.format("Ratpack started %sfor %s://%s:%s", serverConfig.isDevelopment() ? "(development) " : "", this.getScheme(), this.getBindHost(), this.getBindPort());
        if (Slf4jNoBindingDetector.isHasBinding()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(startMessage);
            }
        } else {
            System.out.println(startMessage);
        }
        this.shutdownHookThread = new Thread("ratpack-shutdown-thread"){

            @Override
            public void run() {
                try {
                    DefaultRatpackServer.this.stop();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace(System.err);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    protected DefinitionBuild buildUserDefinition() throws Exception {
        return Impositions.impose(this.impositions, () -> {
            try {
                return new DefinitionBuild(this.impositions, RatpackServerDefinition.build(this.definitionFactory), null);
            }
            catch (Exception e) {
                return new DefinitionBuild(this.impositions, RatpackServerDefinition.build(s -> s.handler(r -> ctx -> ctx.error(e))), e);
            }
        });
    }

    private ChannelHandler buildHandler(DefinitionBuild definitionBuild) throws Exception {
        if (definitionBuild.getServerConfig().isDevelopment()) {
            return new ReloadHandler(definitionBuild);
        }
        return this.buildAdapter(definitionBuild);
    }

    protected Channel buildChannel(final ServerConfig serverConfig, final ChannelHandler handlerAdapter) throws InterruptedException {
        final SSLContext sslContext = serverConfig.getSslContext();
        final boolean requireClientSslAuth = serverConfig.isRequireClientSslAuth();
        this.useSsl = sslContext != null;
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverConfig.getConnectTimeoutMillis().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, i);
            serverBootstrap.childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, i);
        });
        serverConfig.getMaxMessagesPerRead().ifPresent(i -> {
            FixedRecvByteBufAllocator allocator = new FixedRecvByteBufAllocator(i.intValue());
            serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)allocator);
            serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)allocator);
        });
        serverConfig.getReceiveBufferSize().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.SO_RCVBUF, i);
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, i);
        });
        serverConfig.getWriteSpinCount().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.WRITE_SPIN_COUNT, i);
            serverBootstrap.childOption(ChannelOption.WRITE_SPIN_COUNT, i);
        });
        return ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.execController.getEventLoopGroup()).channel(ChannelImplDetector.getServerSocketChannelImpl())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslContext != null) {
                    SSLEngine sslEngine = sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(false);
                    sslEngine.setNeedClientAuth(requireClientSslAuth);
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, serverConfig.getMaxChunkSize(), false));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("deflater", (ChannelHandler)new IgnorableHttpContentCompressor());
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("adapter", handlerAdapter);
                ch.config().setAutoRead(false);
            }
        }).bind((SocketAddress)this.buildSocketAddress(serverConfig)).sync().channel();
    }

    protected NettyHandlerAdapter buildAdapter(DefinitionBuild definition) throws Exception {
        LOGGER.info("Building registry...");
        this.serverRegistry = this.buildServerRegistry(definition.getServerConfig(), definition.getUserRegistryFactory());
        Handler ratpackHandler = this.buildRatpackHandler(this.serverRegistry, definition.getHandlerFactory());
        ratpackHandler = this.decorateHandler(ratpackHandler, this.serverRegistry);
        this.servicesGraph = new ServicesGraph(this.serverRegistry);
        this.servicesGraph.start(new DefaultEvent(this.serverRegistry, this.reloading));
        return new NettyHandlerAdapter(this.serverRegistry, ratpackHandler);
    }

    private Registry buildServerRegistry(ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        return ServerRegistry.serverRegistry(this, this.impositions, this.execController, serverConfig, userRegistryFactory);
    }

    private Handler decorateHandler(Handler rootHandler, Registry serverRegistry) throws Exception {
        Iterable<HandlerDecorator> all = serverRegistry.getAll(HANDLER_DECORATOR_TYPE_TOKEN);
        for (HandlerDecorator handlerDecorator : all) {
            rootHandler = handlerDecorator.decorate(serverRegistry, rootHandler);
        }
        return rootHandler;
    }

    private Handler buildRatpackHandler(Registry serverRegistry, Function<? super Registry, ? extends Handler> handlerFactory) throws Exception {
        return handlerFactory.apply(serverRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        block11: {
            if (!this.isRunning()) {
                return;
            }
            Channel lastChannel = this.channel;
            this.channel = null;
            try {
                if (this.shutdownHookThread != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("Stopping server...");
            if (lastChannel != null) {
                lastChannel.close().sync();
            }
            try {
                if (this.execController == null) break block11;
                try {
                    this.shutdownServices();
                }
                finally {
                    this.execController.close();
                }
            }
            finally {
                this.execController = null;
            }
        }
        LOGGER.info("Server stopped.");
    }

    private void shutdownServices() throws Exception {
        if (this.servicesGraph != null) {
            this.servicesGraph.stop(new DefaultEvent(this.serverRegistry, this.reloading));
        }
    }

    @Override
    public synchronized RatpackServer reload() throws Exception {
        this.reloading = true;
        boolean start = false;
        if (this.isRunning()) {
            start = true;
            this.stop();
        }
        if (start) {
            this.start();
        }
        this.reloading = false;
        return this;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.channel != null;
    }

    @Override
    public synchronized String getScheme() {
        return this.isRunning() ? (this.useSsl ? "https" : "http") : null;
    }

    @Override
    public synchronized int getBindPort() {
        return this.boundAddress == null ? -1 : this.boundAddress.getPort();
    }

    @Override
    public synchronized String getBindHost() {
        if (this.boundAddress == null) {
            return null;
        }
        return HostUtil.determineHost(this.boundAddress);
    }

    private InetSocketAddress buildSocketAddress(ServerConfig serverConfig) {
        return serverConfig.getAddress() == null ? new InetSocketAddress(serverConfig.getPort()) : new InetSocketAddress(serverConfig.getAddress(), serverConfig.getPort());
    }

    static {
        if (System.getProperty("io.netty.leakDetectionLevel", null) == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        HANDLER_DECORATOR_TYPE_TOKEN = Types.token(HandlerDecorator.class);
        LOGGER = LoggerFactory.getLogger(RatpackServer.class);
    }

    @ChannelHandler.Sharable
    class ReloadHandler
    extends ChannelInboundHandlerAdapter {
        private ServerConfig lastServerConfig;
        private DefinitionBuild definitionBuild;
        private final Throttle reloadThrottle = Throttle.ofSize(1);
        private ChannelHandler inner;

        public ReloadHandler(DefinitionBuild definition) {
            this.definitionBuild = definition;
            this.lastServerConfig = this.definitionBuild.getServerConfig();
            try {
                this.inner = DefaultRatpackServer.this.buildAdapter(this.definitionBuild);
            }
            catch (Exception e) {
                LOGGER.warn("An error occurred during startup. This will be ignored due to being in development mode.", (Throwable)e);
                this.inner = null;
                DefaultRatpackServer.this.serverRegistry = DefaultRatpackServer.this.buildServerRegistry(this.lastServerConfig, r -> r);
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.read();
            super.channelActive(ctx);
        }

        ChannelHandler getDelegate() {
            return this.inner;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            DefaultRatpackServer.this.execController.fork().eventLoop(ctx.channel().eventLoop()).start(e -> Promise.async(f -> {
                Optional<ReloadInformant> reloadInformant;
                boolean rebuild = false;
                if (this.inner == null || this.definitionBuild.error != null) {
                    rebuild = true;
                } else if (msg instanceof HttpRequest && (reloadInformant = DefaultRatpackServer.this.serverRegistry.first(RELOAD_INFORMANT_TYPE, r -> r.shouldReload(DefaultRatpackServer.this.serverRegistry) ? r : null)).isPresent()) {
                    LOGGER.debug("reload requested by '" + reloadInformant.get() + "'");
                    rebuild = true;
                }
                if (rebuild) {
                    Blocking.get(() -> {
                        this.definitionBuild = DefaultRatpackServer.this.buildUserDefinition();
                        this.lastServerConfig = this.definitionBuild.getServerConfig();
                        return DefaultRatpackServer.this.buildAdapter(this.definitionBuild);
                    }).wiretap(r -> {
                        if (r.isSuccess()) {
                            this.inner = (ChannelHandler)r.getValue();
                        }
                    }).mapError(this::buildErrorRenderingAdapter).result(f::accept);
                } else {
                    f.success(this.inner);
                }
            }).wiretap(r -> {
                try {
                    ctx.pipeline().remove("inner");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ctx.pipeline().addLast("inner", (ChannelHandler)r.getValueOrThrow());
            }).throttled(this.reloadThrottle).then(adapter -> ctx.fireChannelRead(msg)));
        }

        private NettyHandlerAdapter buildErrorRenderingAdapter(Throwable e) {
            try {
                return new NettyHandlerAdapter(DefaultRatpackServer.this.serverRegistry, context -> context.error(e));
            }
            catch (Exception e1) {
                throw Exceptions.uncheck(e);
            }
        }
    }

    private static class DefinitionBuild {
        private final Impositions impositions;
        private final RatpackServerDefinition definition;
        private final Throwable error;
        private final ServerConfig serverConfig;
        private final Function<? super Registry, ? extends Registry> userRegistryFactory;

        public DefinitionBuild(Impositions impositions, RatpackServerDefinition definition, Throwable error) {
            this.impositions = impositions;
            this.definition = definition;
            this.error = error;
            this.serverConfig = definition.getServerConfig();
            this.userRegistryFactory = baseRegistry -> {
                Registry userRegistry = definition.getRegistry().apply((Registry)baseRegistry);
                Registry userRegistryOverrides = impositions.get(UserRegistryImposition.class).orElse(UserRegistryImposition.none()).build(userRegistry);
                return userRegistry.join(userRegistryOverrides);
            };
        }

        public Impositions getImpositions() {
            return this.impositions;
        }

        public ServerConfig getServerConfig() {
            return this.serverConfig;
        }

        public Function<? super Registry, ? extends Registry> getUserRegistryFactory() {
            return this.userRegistryFactory;
        }

        public Function<? super Registry, ? extends Handler> getHandlerFactory() {
            return this.definition.getHandler();
        }
    }
}

