/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.module;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import ratpack.ssl.SSLContexts;
import ratpack.util.Exceptions;

public class SSLContextDeserializer
extends JsonDeserializer<SSLContext> {
    public SSLContext deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectNode node = (ObjectNode)jp.readValueAsTree();
        try {
            String keyStoreFile = node.path("keystoreFile").asText();
            String keyStorePassword = node.path("keystorePassword").asText();
            String trustStoreFile = node.path("truststoreFile").asText();
            String trustStorePassword = node.path("truststorePassword").asText();
            if (keyStoreFile.isEmpty()) {
                throw new IllegalStateException("keystoreFile must be set if any ssl properties are set");
            }
            if (keyStorePassword.isEmpty()) {
                throw new IllegalStateException("keystorePassword must be set if any ssl properties are set");
            }
            if (!trustStoreFile.isEmpty() && trustStorePassword.isEmpty()) {
                throw new IllegalStateException("truststorePassword must be specified when truststoreFile is specified");
            }
            if (trustStoreFile.isEmpty()) {
                return SSLContexts.sslContext(Paths.get(keyStoreFile, new String[0]), keyStorePassword);
            }
            return SSLContexts.sslContext(Paths.get(keyStoreFile, new String[0]), keyStorePassword, Paths.get(trustStoreFile, new String[0]), trustStorePassword);
        }
        catch (GeneralSecurityException ex) {
            throw Exceptions.uncheck(ex);
        }
    }
}

