/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.checksummer.internal;

import java.io.InputStream;
import java.util.zip.Adler32;
import ratpack.func.Function;

public class Adler32Checksummer
implements Function<InputStream, String> {
    private static final int BUFFER_SIZE = 8192;

    @Override
    public String apply(InputStream is) throws Exception {
        byte[] buffer = new byte[8192];
        Adler32 checksum = new Adler32();
        int read = is.read(buffer, 0, 8192);
        while (read != -1) {
            checksum.update(buffer, 0, read);
            read = is.read(buffer, 0, 8192);
        }
        return Long.toHexString(checksum.getValue());
    }
}

