/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import java.net.URI;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.exec.Upstream;
import ratpack.func.Action;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.HttpClientInternal;
import ratpack.http.client.internal.RequestActionSupport;

class ContentAggregatingRequestAction
extends RequestActionSupport<ReceivedResponse> {
    private static final String AGGREGATOR_HANDLER_NAME = "aggregator";
    private static final String RESPONSE_HANDLER_NAME = "response";

    ContentAggregatingRequestAction(URI uri, HttpClientInternal client, int redirectCount, Execution execution, Action<? super RequestSpec> requestConfigurer) {
        super(uri, client, redirectCount, execution, requestConfigurer);
    }

    @Override
    protected void disposeChannel(ChannelPipeline channelPipeline, boolean forceClose) {
        channelPipeline.remove(AGGREGATOR_HANDLER_NAME);
        channelPipeline.remove(RESPONSE_HANDLER_NAME);
        super.disposeChannel(channelPipeline, forceClose);
    }

    @Override
    protected void addResponseHandlers(ChannelPipeline p, final Downstream<? super ReceivedResponse> downstream) {
        p.addLast(AGGREGATOR_HANDLER_NAME, (ChannelHandler)new HttpObjectAggregator(this.requestConfig.maxContentLength));
        p.addLast(RESPONSE_HANDLER_NAME, (ChannelHandler)new SimpleChannelInboundHandler<FullHttpResponse>(false){

            protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                ContentAggregatingRequestAction.this.disposeChannel(ctx.pipeline(), !HttpUtil.isKeepAlive((HttpMessage)msg));
                ByteBuf content = msg.content();
                ContentAggregatingRequestAction.this.execution.onComplete(() -> {
                    if (content.refCnt() > 0) {
                        content.release();
                    }
                });
                ContentAggregatingRequestAction.this.success(downstream, ContentAggregatingRequestAction.this.toReceivedResponse((HttpResponse)msg, content));
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ContentAggregatingRequestAction.this.disposeChannel(ctx.pipeline(), true);
                ContentAggregatingRequestAction.this.error(downstream, cause);
            }
        });
    }

    @Override
    protected Upstream<ReceivedResponse> onRedirect(URI locationUrl, int redirectCount, Action<? super RequestSpec> redirectRequestConfig) {
        return new ContentAggregatingRequestAction(locationUrl, this.client, redirectCount, this.execution, redirectRequestConfig);
    }
}

