/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import ratpack.http.Headers;
import ratpack.http.Response;
import ratpack.http.Status;
import ratpack.http.TypedData;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.internal.ByteBufBackedTypedData;

public class DefaultReceivedResponse
implements ReceivedResponse {
    private final Status status;
    private final Headers headers;
    private final ByteBufBackedTypedData typedData;

    public DefaultReceivedResponse(Status status, Headers headers, ByteBufBackedTypedData typedData) {
        this.status = status;
        this.headers = headers;
        this.typedData = typedData;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public int getStatusCode() {
        return this.status.getCode();
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public TypedData getBody() {
        return this.typedData;
    }

    @Override
    public void forwardTo(Response response) {
        response.getHeaders().copy(this.headers);
        response.status(this.status).send(this.typedData.getBuffer().retain());
    }
}

