/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.path.internal.DefaultPathTokens;
import ratpack.path.internal.RootPathBinding;

public class DefaultPathBinding
implements PathBinding {
    private final String binding;
    private final String pastBinding;
    private final PathBinding parent;
    private final String description;
    private final PathTokens tokens;
    private final PathTokens allTokens;

    public DefaultPathBinding(String binding, ImmutableMap<String, String> tokens, PathBinding parent, String description) {
        this.binding = binding;
        this.parent = parent;
        this.description = description;
        this.tokens = DefaultPathTokens.of(tokens);
        this.allTokens = DefaultPathBinding.mergeTokens(this.tokens, parent.getAllTokens());
        String bindingWithSlash = binding.concat("/");
        String path = parent.getPastBinding();
        if (path.equals(binding)) {
            this.pastBinding = "";
        } else if (path.startsWith(bindingWithSlash)) {
            this.pastBinding = path.substring(bindingWithSlash.length());
        } else {
            throw new IllegalArgumentException(String.format("Path '%s' is not a child of '%s'", path, binding));
        }
    }

    private static PathTokens mergeTokens(PathTokens thisTokens, PathTokens parentTokens) {
        if (parentTokens.isEmpty()) {
            return thisTokens;
        }
        if (thisTokens.isEmpty()) {
            return parentTokens;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Sets.difference(parentTokens.keySet(), thisTokens.keySet()).forEach(t -> builder.put(t, parentTokens.get(t)));
        builder.putAll((Map)thisTokens);
        return DefaultPathTokens.of((ImmutableMap<String, String>)builder.build());
    }

    @Override
    public String getDescription() {
        return this.parent instanceof RootPathBinding ? this.description : this.parent.getDescription() + "/" + this.description;
    }

    @Override
    public String getPastBinding() {
        return this.pastBinding;
    }

    @Override
    public String getBoundTo() {
        return this.binding;
    }

    @Override
    public PathTokens getTokens() {
        return this.tokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPathBinding that = (DefaultPathBinding)o;
        return this.binding.equals(that.binding) && this.pastBinding.equals(that.pastBinding) && this.description.equals(that.description) && this.allTokens.equals(that.allTokens);
    }

    public int hashCode() {
        int result = this.binding.hashCode();
        result = 31 * result + this.pastBinding.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.allTokens.hashCode();
        return result;
    }

    @Override
    public PathTokens getAllTokens() {
        return this.allTokens;
    }
}

