/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.Iterator;
import org.reactivestreams.Subscriber;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.internal.SubscriptionSupport;

public class IterablePublisher<T>
implements TransformablePublisher<T> {
    private final Iterable<? extends T> iterable;

    public IterablePublisher(Iterable<? extends T> iterable) {
        this.iterable = iterable;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Iterator<? extends T> iterator = this.iterable.iterator();
        new Subscription(subscriber, iterator);
    }

    private class Subscription
    extends SubscriptionSupport<T> {
        private final Iterator<? extends T> iterator;

        public Subscription(Subscriber<? super T> subscriber, Iterator<? extends T> iterator) {
            super(subscriber);
            this.iterator = iterator;
            this.start();
        }

        @Override
        protected void doRequest(long n) {
            int i = 0;
            while ((long)i < n && !this.isStopped()) {
                if (this.iterator.hasNext()) {
                    Object next;
                    try {
                        next = this.iterator.next();
                    }
                    catch (Exception e) {
                        this.onError(e);
                        return;
                    }
                    this.onNext(next);
                } else {
                    this.onComplete();
                }
                ++i;
            }
        }
    }
}

