/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import ratpack.registry.Registry;
import ratpack.util.Types;

public class CachingRegistry
implements Registry {
    private final Registry delegate;
    private final Map<TypeToken<?>, Optional<?>> cache = new ConcurrentHashMap();
    private final Map<TypeToken<?>, Iterable<?>> allCache = new ConcurrentHashMap();
    private final Function<TypeToken<?>, Optional<?>> maybeGet;
    private final Function<TypeToken<?>, Iterable<?>> getAll;

    public static Registry of(Registry registry) {
        if (registry instanceof CachingRegistry) {
            return registry;
        }
        return new CachingRegistry(registry);
    }

    private CachingRegistry(Registry delegate) {
        this.delegate = delegate;
        this.maybeGet = delegate::maybeGet;
        this.getAll = delegate::getAll;
    }

    private static <K, V> V compute(Map<K, V> map, K key, Function<? super K, ? extends V> supplier) {
        V value = map.get(key);
        if (value == null) {
            value = supplier.apply(key);
            map.put(key, value);
        }
        return value;
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        return (Optional)Types.cast(CachingRegistry.compute(this.cache, type, this.maybeGet));
    }

    public <O> Iterable<O> getAll(TypeToken<O> type) {
        return (Iterable)Types.cast(CachingRegistry.compute(this.allCache, type, this.getAll));
    }

    public String toString() {
        return "CachingRegistry{delegate=" + this.delegate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingRegistry that = (CachingRegistry)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

