/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.CharsetUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import ratpack.sse.Event;

public class ServerSentEventEncoder {
    public static final ServerSentEventEncoder INSTANCE = new ServerSentEventEncoder();
    private static final byte[] EVENT_TYPE_PREFIX = "event: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] EVENT_DATA_PREFIX = "data: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] EVENT_ID_PREFIX = "id: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] NEWLINE = "\n".getBytes(CharsetUtil.UTF_8);

    public ByteBuf encode(Event<?> event, ByteBufAllocator bufferAllocator) throws Exception {
        String eventId;
        String eventData;
        ByteBuf buffer = bufferAllocator.buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, CharsetUtil.encoder((Charset)CharsetUtil.UTF_8));
        String eventType = event.getEvent();
        if (eventType != null) {
            outputStream.write(EVENT_TYPE_PREFIX);
            ((Writer)writer).append(eventType).flush();
            outputStream.write(NEWLINE);
        }
        if ((eventData = event.getData()) != null) {
            outputStream.write(EVENT_DATA_PREFIX);
            for (Character character : Lists.charactersOf((String)eventData)) {
                if (character.charValue() == '\n') {
                    outputStream.write(NEWLINE);
                    outputStream.write(EVENT_DATA_PREFIX);
                    continue;
                }
                writer.append(character.charValue()).flush();
            }
            outputStream.write(NEWLINE);
        }
        if ((eventId = event.getId()) != null) {
            outputStream.write(EVENT_ID_PREFIX);
            ((Writer)writer).append(eventId).flush();
            outputStream.write(NEWLINE);
        }
        outputStream.write(NEWLINE);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return buffer;
    }
}

