/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream;

import org.reactivestreams.Subscription;
import ratpack.func.Action;

public interface WriteStream<T> {
    public void item(T var1);

    public void error(Throwable var1);

    public void complete();

    default public <O> WriteStream<O> itemMap(final Subscription subscription, final Action<? super O> itemMapper) {
        return new WriteStream<O>(){

            @Override
            public void item(O item) {
                try {
                    itemMapper.execute(item);
                }
                catch (Exception e) {
                    subscription.cancel();
                    this.error(e);
                }
            }

            @Override
            public void error(Throwable throwable) {
                WriteStream.this.error(throwable);
            }

            @Override
            public void complete() {
                WriteStream.this.complete();
            }
        };
    }

    @Deprecated
    default public <O> WriteStream<O> itemMap(final Action<? super O> itemMapper) {
        return new WriteStream<O>(){

            @Override
            public void item(O item) {
                try {
                    itemMapper.execute(item);
                }
                catch (Exception e) {
                    this.error(e);
                }
            }

            @Override
            public void error(Throwable throwable) {
                WriteStream.this.error(throwable);
            }

            @Override
            public void complete() {
                WriteStream.this.complete();
            }
        };
    }
}

