/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.util;

import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.exec.Downstream;
import ratpack.exec.ExecResult;
import ratpack.exec.Promise;
import ratpack.exec.Result;

public final class Promised<T>
implements Downstream<T> {
    private final AtomicReference<ExecResult<? extends T>> ref = new AtomicReference();
    private final Queue<Downstream<? super T>> listeners = PlatformDependent.newMpscQueue();

    public Promise<T> promise() {
        return Promise.async(downstream -> {
            ExecResult<? extends T> result = this.ref.get();
            if (result == null) {
                this.listeners.add(downstream);
                this.drain();
            } else {
                downstream.accept(result);
            }
        });
    }

    @Override
    public void success(T value) {
        this.accept(ExecResult.of(Result.success(value)));
    }

    @Override
    public void error(Throwable throwable) {
        this.accept(ExecResult.of(Result.error(throwable)));
    }

    @Override
    public void complete() {
        this.accept(ExecResult.complete());
    }

    @Override
    public void accept(ExecResult<? extends T> result) {
        if (!this.ref.compareAndSet(null, result)) {
            throw new AlreadySuppliedException("promised has already been completed with " + this.ref.get());
        }
        this.drain();
    }

    private void drain() {
        ExecResult<? extends T> result = this.ref.get();
        if (result == null) {
            return;
        }
        Downstream<? extends T> next = this.listeners.poll();
        while (next != null) {
            next.accept(result);
            next = this.listeners.poll();
        }
    }

    public static class AlreadySuppliedException
    extends IllegalStateException {
        private AlreadySuppliedException(String s) {
            super(s);
        }
    }
}

