/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import io.netty.util.internal.PlatformDependent;
import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.internal.BufferedWriteStream;

public class BufferingPublisher<T>
implements TransformablePublisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferingPublisher.class);
    private static final Object ON_COMPLETE = new Object();
    private static final Object ON_ERROR = new Object();
    private static final Object CANCEL = new Object();
    private final Action<? super T> disposer;
    private final Function<? super BufferedWriteStream<T>, Subscription> function;

    public BufferingPublisher(Action<? super T> disposer, Publisher<T> publisher) {
        this(disposer, (? super BufferedWriteStream<T> write) -> new ConnectingSubscriber(publisher, write));
    }

    public BufferingPublisher(Action<? super T> disposer, Function<? super BufferedWriteStream<T>, Subscription> function) {
        this.disposer = disposer;
        this.function = function;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        new BufferingSubscription(subscriber);
    }

    private class BufferingSubscription
    implements Subscription {
        private final Deque<T> buffer = new ConcurrentLinkedDeque();
        private final AtomicLong wanted = new AtomicLong();
        private final AtomicBoolean draining = new AtomicBoolean();
        private volatile boolean open;
        private volatile Subscription upstreamSubscription;
        private volatile Subscriber<? super T> downstream;
        private volatile Throwable error;
        private final BufferedWriteStream<T> writeStream = new WriteStream();

        public BufferingSubscription(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            downstream.onSubscribe((Subscription)this);
            this.open = true;
            this.drain();
        }

        private void drain() {
            if (this.draining.compareAndSet(false, true)) {
                Object peek;
                try {
                    Object item = this.buffer.poll();
                    while (item != null) {
                        if (item == ON_COMPLETE) {
                            if (this.downstream != null) {
                                this.downstream.onComplete();
                                this.downstream = null;
                            }
                        } else if (item == ON_ERROR) {
                            if (this.downstream != null) {
                                assert (this.error != null);
                                this.downstream.onError(this.error);
                                this.downstream = null;
                            }
                        } else if (this.downstream == null || this.error != null) {
                            try {
                                BufferingPublisher.this.disposer.execute(item);
                            }
                            catch (Exception e) {
                                LOGGER.warn("exception raised disposing of " + item + " - will be ignored", (Throwable)e);
                            }
                        } else if (this.wanted.get() > 0L) {
                            this.downstream.onNext(item);
                            if (this.wanted.decrementAndGet() == 0L) {
                                break;
                            }
                        } else {
                            this.buffer.push(item);
                            break;
                        }
                        item = this.buffer.poll();
                    }
                }
                finally {
                    this.draining.set(false);
                }
                if ((peek = this.buffer.peek()) != null && (this.wanted.get() > 0L || peek == ON_COMPLETE || peek == ON_ERROR)) {
                    this.drain();
                }
            }
        }

        public void request(long n) {
            if (this.downstream == null) {
                return;
            }
            if (n < 1L) {
                this.downstream.onError((Throwable)new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                this.cancel();
            }
            if (this.upstreamSubscription == null) {
                try {
                    this.upstreamSubscription = (Subscription)BufferingPublisher.this.function.apply(this.writeStream);
                }
                catch (Exception e) {
                    this.writeStream.error(e);
                    return;
                }
            }
            if (this.wanted.get() < Long.MAX_VALUE) {
                long nowWanted = this.wanted.addAndGet(n);
                if (nowWanted == Long.MAX_VALUE || nowWanted < 0L) {
                    this.wanted.set(Long.MAX_VALUE);
                    this.upstreamSubscription.request(Long.MAX_VALUE);
                } else {
                    long outstanding = nowWanted - (long)this.buffer.size();
                    if (outstanding > 0L) {
                        this.upstreamSubscription.request(outstanding);
                    }
                }
            }
            this.drain();
        }

        public void cancel() {
            this.downstream = null;
            if (this.upstreamSubscription != null) {
                this.upstreamSubscription.cancel();
            }
            this.drain();
        }

        class WriteStream
        implements BufferedWriteStream<T> {
            WriteStream() {
            }

            @Override
            public void item(T item) {
                BufferingSubscription.this.buffer.add(item);
                if (BufferingSubscription.this.open) {
                    BufferingSubscription.this.drain();
                }
            }

            @Override
            public void error(Throwable throwable) {
                BufferingSubscription.this.error = throwable;
                BufferingSubscription.this.buffer.add(ON_ERROR);
                if (BufferingSubscription.this.open) {
                    BufferingSubscription.this.drain();
                }
            }

            @Override
            public void complete() {
                BufferingSubscription.this.buffer.add(ON_COMPLETE);
                if (BufferingSubscription.this.open) {
                    BufferingSubscription.this.drain();
                }
            }

            @Override
            public long getRequested() {
                return BufferingSubscription.this.wanted.get();
            }

            @Override
            public long getBuffered() {
                return BufferingSubscription.this.buffer.size();
            }
        }
    }

    private static class ConnectingSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        private final Publisher<T> publisher;
        private final BufferedWriteStream<T> write;
        private volatile Subscription upstream;
        private final AtomicBoolean connected = new AtomicBoolean();
        private final AtomicBoolean draining = new AtomicBoolean();
        private final Queue<Object> signals = PlatformDependent.newMpscQueue();

        public ConnectingSubscriber(Publisher<T> publisher, BufferedWriteStream<T> write) {
            this.publisher = publisher;
            this.write = write;
        }

        public void request(long n) {
            this.signals.add(n);
            if (this.connected.compareAndSet(false, true)) {
                this.publisher.subscribe((Subscriber)this);
            } else {
                this.drain();
            }
        }

        public void cancel() {
            this.signals.add(CANCEL);
            this.drain();
        }

        private void drain() {
            if (this.draining.compareAndSet(false, true)) {
                try {
                    Subscription upstreamRead = this.upstream;
                    if (upstreamRead != null) {
                        Object signal = this.signals.poll();
                        while (signal != null) {
                            if (signal == CANCEL) {
                                upstreamRead.cancel();
                            } else {
                                upstreamRead.request(((Long)signal).longValue());
                            }
                            signal = this.signals.poll();
                        }
                    }
                }
                finally {
                    this.draining.set(false);
                }
                if (!this.signals.isEmpty() && this.upstream != null) {
                    this.drain();
                }
            }
        }

        public void onSubscribe(Subscription s) {
            this.upstream = s;
            this.drain();
        }

        public void onNext(T t) {
            this.write.item(t);
        }

        public void onError(Throwable t) {
            this.write.error(t);
        }

        public void onComplete() {
            this.write.complete();
        }
    }
}

