/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import com.google.common.reflect.TypeToken;
import io.netty.channel.EventLoop;
import java.util.function.Supplier;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.ExecStarter;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.DefaultExecution;
import ratpack.exec.internal.ThreadBinding;
import ratpack.func.Block;
import ratpack.registry.MutableRegistry;

public interface Execution
extends MutableRegistry {
    public static Execution current() throws UnmanagedThreadException {
        return DefaultExecution.require();
    }

    public static ExecStarter fork() throws UnmanagedThreadException {
        return ExecController.require().fork();
    }

    public static boolean isManagedThread() {
        return ThreadBinding.get().isPresent();
    }

    public static boolean isComputeThread() {
        return ThreadBinding.get().map(ThreadBinding::isCompute).orElse(false);
    }

    public static boolean isBlockingThread() {
        return ThreadBinding.get().map(threadBinding -> !threadBinding.isCompute()).orElse(false);
    }

    public ExecController getController();

    public EventLoop getEventLoop();

    public void onComplete(AutoCloseable var1);

    @Override
    default public <O> Execution add(Class<O> type, O object) {
        MutableRegistry.super.add(type, object);
        return this;
    }

    @Override
    default public <O> Execution add(TypeToken<O> type, O object) {
        MutableRegistry.super.add(type, object);
        return this;
    }

    @Override
    default public Execution add(Object object) {
        MutableRegistry.super.add(object);
        return this;
    }

    @Override
    default public <O> Execution addLazy(Class<O> type, Supplier<? extends O> supplier) {
        MutableRegistry.super.addLazy(type, supplier);
        return this;
    }

    @Override
    public <O> Execution addLazy(TypeToken<O> var1, Supplier<? extends O> var2);

    public void addInterceptor(ExecInterceptor var1, Block var2) throws Exception;
}

