/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import com.google.common.net.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.exec.Upstream;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.http.client.HttpClientReadTimeoutException;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.HttpClientInternal;
import ratpack.http.client.internal.RequestConfig;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultMediaType;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.util.Exceptions;

abstract class RequestActionSupport<T>
implements Upstream<T> {
    private static final Pattern ABSOLUTE_PATTERN = Pattern.compile("^https?://.*");
    private static final String SSL_HANDLER_NAME = "ssl";
    private static final String CLIENT_CODEC_HANDLER_NAME = "clientCodec";
    private static final String READ_TIMEOUT_HANDLER_NAME = "readTimeout";
    private static final String REDIRECT_HANDLER_NAME = "redirect";
    private static final String DECOMPRESS_HANDLER_NAME = "decompressor";
    protected final HttpClientInternal client;
    protected final RequestConfig requestConfig;
    protected final Execution execution;
    private final HttpChannelKey channelKey;
    private ChannelPool channelPool;
    private final int redirectCount;
    private final Action<? super RequestSpec> requestConfigurer;
    private boolean fired;
    private boolean disposed;

    RequestActionSupport(URI uri, HttpClientInternal client, int redirectCount, Execution execution, Action<? super RequestSpec> requestConfigurer) {
        this.requestConfigurer = requestConfigurer;
        this.requestConfig = Exceptions.uncheck(() -> RequestConfig.of(uri, client, requestConfigurer));
        this.client = client;
        this.execution = execution;
        this.redirectCount = redirectCount;
        this.channelKey = new HttpChannelKey(this.requestConfig.uri, this.requestConfig.connectTimeout, execution);
        this.channelPool = client.getChannelPoolMap().get(this.channelKey);
        this.finalizeHeaders();
    }

    protected abstract void addResponseHandlers(ChannelPipeline var1, Downstream<? super T> var2);

    @Override
    public void connect(Downstream<? super T> downstream) throws Exception {
        this.channelPool.acquire().addListener(acquireFuture -> {
            if (acquireFuture.isSuccess()) {
                Channel channel = (Channel)acquireFuture.getNow();
                this.send(downstream, channel);
            } else {
                this.connectFailure(downstream, acquireFuture.cause());
            }
        });
    }

    private void send(Downstream<? super T> downstream, Channel channel) throws Exception {
        channel.config().setAutoRead(true);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, this.requestConfig.method.getNettyMethod(), RequestActionSupport.getFullPath(this.requestConfig.uri), this.requestConfig.body, this.requestConfig.headers.getNettyHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        this.addCommonResponseHandlers(channel.pipeline(), downstream);
        channel.writeAndFlush((Object)request).addListener(writeFuture -> {
            if (!writeFuture.isSuccess()) {
                this.error(downstream, writeFuture.cause());
            }
        });
    }

    private void connectFailure(Downstream<? super T> downstream, Throwable e) {
        if (e instanceof ConnectTimeoutException) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            e = new ConnectTimeoutException("Connect timeout (" + this.requestConfig.connectTimeout + ") connecting to " + this.requestConfig.uri);
            e.setStackTrace(stackTrace);
        }
        this.error(downstream, e);
    }

    private void finalizeHeaders() {
        int contentLength;
        if (this.requestConfig.headers.get(HttpHeaderConstants.HOST) == null) {
            HostAndPort hostAndPort = HostAndPort.fromParts((String)this.channelKey.host, (int)this.channelKey.port);
            this.requestConfig.headers.set(HttpHeaderConstants.HOST, hostAndPort.toString());
        }
        if (this.client.getPoolSize() == 0) {
            this.requestConfig.headers.set(HttpHeaderConstants.CONNECTION, HttpHeaderValues.CLOSE);
        }
        if ((contentLength = this.requestConfig.body.readableBytes()) > 0) {
            this.requestConfig.headers.set(HttpHeaderConstants.CONTENT_LENGTH, Integer.toString(contentLength));
        }
    }

    protected void forceDispose(ChannelPipeline channelPipeline) {
        this.dispose(channelPipeline, true);
    }

    protected void dispose(ChannelPipeline channelPipeline, HttpResponse response) {
        this.dispose(channelPipeline, !HttpUtil.isKeepAlive((HttpMessage)response));
    }

    private void dispose(ChannelPipeline channelPipeline, boolean forceClose) {
        if (!this.disposed) {
            this.disposed = true;
            this.doDispose(channelPipeline, forceClose);
        }
    }

    protected void doDispose(ChannelPipeline channelPipeline, boolean forceClose) {
        channelPipeline.remove(CLIENT_CODEC_HANDLER_NAME);
        channelPipeline.remove(READ_TIMEOUT_HANDLER_NAME);
        channelPipeline.remove(REDIRECT_HANDLER_NAME);
        if (channelPipeline.get(DECOMPRESS_HANDLER_NAME) != null) {
            channelPipeline.remove(DECOMPRESS_HANDLER_NAME);
        }
        if (forceClose) {
            channelPipeline.channel().close();
        }
        this.channelPool.release(channelPipeline.channel());
    }

    private void addCommonResponseHandlers(ChannelPipeline p, final Downstream<? super T> downstream) throws Exception {
        if (this.channelKey.ssl && p.get(SSL_HANDLER_NAME) == null) {
            p.addLast(SSL_HANDLER_NAME, (ChannelHandler)this.createSslHandler());
        }
        p.addLast(CLIENT_CODEC_HANDLER_NAME, (ChannelHandler)new HttpClientCodec(4096, 8192, 8192, false));
        p.addLast(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler(this.requestConfig.readTimeout.toNanos(), TimeUnit.NANOSECONDS));
        p.addLast(REDIRECT_HANDLER_NAME, (ChannelHandler)new SimpleChannelInboundHandler<HttpObject>(false){
            boolean redirected;
            HttpResponse response;

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (cause instanceof ReadTimeoutException) {
                    cause = new HttpClientReadTimeoutException("Read timeout (" + RequestActionSupport.this.requestConfig.readTimeout + ") waiting on HTTP server at " + RequestActionSupport.this.requestConfig.uri);
                }
                RequestActionSupport.this.error(downstream, cause);
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                PrematureChannelClosureException e = new PrematureChannelClosureException("Server " + RequestActionSupport.this.requestConfig.uri + " closed the connection prematurely");
                RequestActionSupport.this.error(downstream, (Throwable)e);
            }

            protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                if (msg instanceof HttpResponse) {
                    this.response = (HttpResponse)msg;
                    int maxRedirects = RequestActionSupport.this.requestConfig.maxRedirects;
                    int status = this.response.status().code();
                    String locationValue = this.response.headers().getAsString(HttpHeaderConstants.LOCATION);
                    Action<RequestSpec> redirectConfigurer = RequestActionSupport.this.requestConfigurer;
                    if (RequestActionSupport.isRedirect(status) && RequestActionSupport.this.redirectCount < maxRedirects && locationValue != null) {
                        Function<? super ReceivedResponse, Action<? super RequestSpec>> onRedirect = RequestActionSupport.this.requestConfig.onRedirect;
                        if (onRedirect != null) {
                            Action<? super RequestSpec> onRedirectResult = onRedirect.apply(RequestActionSupport.this.toReceivedResponse(this.response));
                            redirectConfigurer = onRedirectResult == null ? null : redirectConfigurer.append(onRedirectResult);
                        }
                        if (redirectConfigurer != null) {
                            Action<RequestSpec> redirectRequestConfig = s -> {
                                if (status == 301 || status == 302) {
                                    s.get();
                                }
                            };
                            redirectRequestConfig = redirectRequestConfig.append(redirectConfigurer);
                            URI locationUrl = ABSOLUTE_PATTERN.matcher(locationValue).matches() ? new URI(locationValue) : new URI(((RequestActionSupport)RequestActionSupport.this).channelKey.ssl ? "https" : "http", null, ((RequestActionSupport)RequestActionSupport.this).channelKey.host, ((RequestActionSupport)RequestActionSupport.this).channelKey.port, locationValue, null, null);
                            RequestActionSupport.this.onRedirect(locationUrl, RequestActionSupport.this.redirectCount + 1, redirectRequestConfig).connect(downstream);
                            this.redirected = true;
                            RequestActionSupport.this.dispose(ctx.pipeline(), this.response);
                        }
                    }
                }
                if (!this.redirected) {
                    ctx.fireChannelRead((Object)msg);
                }
            }
        });
        if (this.requestConfig.decompressResponse) {
            p.addLast(DECOMPRESS_HANDLER_NAME, (ChannelHandler)new HttpContentDecompressor());
        }
        this.addResponseHandlers(p, downstream);
    }

    private SslHandler createSslHandler() throws NoSuchAlgorithmException {
        SSLEngine sslEngine = this.requestConfig.sslContext != null ? this.requestConfig.sslContext.createSSLEngine() : SSLContext.getDefault().createSSLEngine();
        sslEngine.setUseClientMode(true);
        return new SslHandler(sslEngine);
    }

    protected abstract Upstream<T> onRedirect(URI var1, int var2, Action<? super RequestSpec> var3);

    protected void success(Downstream<? super T> downstream, T value) {
        if (!this.fired) {
            this.fired = true;
            downstream.success(value);
        }
    }

    protected void error(Downstream<?> downstream, Throwable error) {
        if (!this.fired) {
            this.fired = true;
            downstream.error(error);
        }
    }

    private ReceivedResponse toReceivedResponse(HttpResponse msg) {
        return this.toReceivedResponse(msg, Unpooled.EMPTY_BUFFER);
    }

    protected ReceivedResponse toReceivedResponse(HttpResponse msg, ByteBuf responseBuffer) {
        NettyHeadersBackedHeaders headers = new NettyHeadersBackedHeaders(msg.headers());
        String contentType = headers.get(HttpHeaderConstants.CONTENT_TYPE);
        ByteBufBackedTypedData typedData = new ByteBufBackedTypedData(responseBuffer, DefaultMediaType.get(contentType));
        DefaultStatus status = new DefaultStatus(msg.status());
        return new DefaultReceivedResponse(status, headers, typedData);
    }

    private static boolean isRedirect(int code) {
        return code == 301 || code == 302 || code == 303 || code == 307;
    }

    private static String getFullPath(URI uri) {
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        String fragment = uri.getRawFragment();
        if (query == null && fragment == null) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path);
        if (query != null) {
            sb.append("?").append(query);
        }
        if (fragment != null) {
            sb.append("#").append(fragment);
        }
        return sb.toString();
    }
}

