/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainHandler;
import ratpack.path.PathBinder;
import ratpack.path.PathBinding;
import ratpack.path.internal.PathBindingStorage;

public class PathHandler
implements Handler {
    private static final int CACHE_SIZE = Integer.parseInt(System.getProperty("ratpack.cachesize.path", "10000"));
    private static final Handler POP_BINDING = ctx -> {
        ctx.getExecution().get(PathBindingStorage.TYPE).pop();
        ctx.next();
    };
    private final PathBinder binder;
    private final Handler[] handler;
    private final Cache<PathBinding, Optional<PathBinding>> cache = Caffeine.newBuilder().maximumSize((long)CACHE_SIZE).build();

    public PathHandler(PathBinder binder, Handler handler) {
        this.binder = binder;
        Handler[] unpacked = ChainHandler.unpack(handler);
        Handler[] withPop = new Handler[unpacked.length + 1];
        System.arraycopy(unpacked, 0, withPop, 0, unpacked.length);
        withPop[unpacked.length] = POP_BINDING;
        this.handler = withPop;
    }

    @Override
    public void handle(Context ctx) throws ExecutionException {
        PathBindingStorage pathBindings = ctx.getExecution().get(PathBindingStorage.TYPE);
        PathBinding pathBinding = (PathBinding)pathBindings.peek();
        Optional newBinding = (Optional)this.cache.get((Object)pathBinding, this.binder::bind);
        if (newBinding.isPresent()) {
            pathBindings.push(newBinding.get());
            ctx.insert(this.handler);
        } else {
            ctx.next();
        }
    }
}

