/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Optional;
import ratpack.file.FileHandlerSpec;
import ratpack.func.Action;
import ratpack.func.Predicate;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;

public interface Chain {
    default public Chain files(Action<? super FileHandlerSpec> config) throws Exception {
        return this.all(Handlers.files(this.getServerConfig(), config));
    }

    default public Chain files() {
        return Exceptions.uncheck(() -> this.files(Action.noop()));
    }

    default public Handler chain(Action<? super Chain> action) throws Exception {
        return Handlers.chain(this.getServerConfig(), this.getRegistry(), action);
    }

    default public Handler chain(Class<? extends Action<? super Chain>> action) throws Exception {
        return this.chain(this.getRegistry().get(action));
    }

    default public Chain delete(String path, Handler handler) {
        return this.all(Handlers.path(path, Handlers.chain(Handlers.delete(), handler)));
    }

    default public Chain delete(String path, Class<? extends Handler> handler) {
        return this.delete(path, this.getRegistry().get(handler));
    }

    default public Chain delete(Handler handler) {
        return this.delete("", handler);
    }

    default public Chain delete(Class<? extends Handler> handler) {
        return this.delete(this.getRegistry().get(handler));
    }

    default public Chain fileSystem(String path, Action<? super Chain> action) throws Exception {
        return this.all(Handlers.fileSystem(this.getServerConfig(), path, this.chain(action)));
    }

    default public Chain fileSystem(String path, Class<? extends Action<? super Chain>> action) throws Exception {
        return this.fileSystem(path, this.getRegistry().get(action));
    }

    default public Chain get(String path, Handler handler) {
        return this.all(Handlers.path(path, Handlers.chain(Handlers.get(), handler)));
    }

    default public Chain get(String path, Class<? extends Handler> handler) {
        return this.get(path, this.getRegistry().get(handler));
    }

    default public Chain get(Handler handler) {
        return this.get("", handler);
    }

    default public Chain get(Class<? extends Handler> handler) {
        return this.get(this.getRegistry().get(handler));
    }

    public ServerConfig getServerConfig();

    public Registry getRegistry() throws IllegalStateException;

    public Chain all(Handler var1);

    default public Chain all(Class<? extends Handler> handler) {
        return this.all(this.getRegistry().get(handler));
    }

    default public Chain path(String path, Handler handler) {
        return this.all(Handlers.path(path, handler));
    }

    default public Chain path(Handler handler) {
        return this.path("", handler);
    }

    default public Chain path(String path, Class<? extends Handler> handler) {
        return this.path(path, this.getRegistry().get(handler));
    }

    default public Chain path(Class<? extends Handler> handler) {
        return this.path("", handler);
    }

    default public Chain host(String hostName, Action<? super Chain> action) throws Exception {
        return this.when((? super Context ctx) -> Optional.ofNullable(ctx.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.HOST)).map(s -> s.equals(hostName)).orElse(false), action);
    }

    default public Chain host(String hostName, Class<? extends Action<? super Chain>> action) throws Exception {
        return this.host(hostName, this.getRegistry().get(action));
    }

    default public Chain insert(Action<? super Chain> action) throws Exception {
        return this.all(this.chain(action));
    }

    default public Chain insert(Class<? extends Action<? super Chain>> action) throws Exception {
        return this.insert(this.getRegistry().get(action));
    }

    default public Chain patch(String path, Handler handler) {
        return this.all(Handlers.path(path, Handlers.chain(Handlers.patch(), handler)));
    }

    default public Chain patch(String path, Class<? extends Handler> handler) {
        return this.patch(path, this.getRegistry().get(handler));
    }

    default public Chain patch(Handler handler) {
        return this.patch("", handler);
    }

    default public Chain patch(Class<? extends Handler> handler) {
        return this.patch(this.getRegistry().get(handler));
    }

    default public Chain options(String path, Handler handler) {
        return this.all(Handlers.path(path, Handlers.chain(Handlers.options(), handler)));
    }

    default public Chain options(String path, Class<? extends Handler> handler) {
        return this.options(path, this.getRegistry().get(handler));
    }

    default public Chain options(Handler handler) {
        return this.options("", handler);
    }

    default public Chain options(Class<? extends Handler> handler) {
        return this.options(this.getRegistry().get(handler));
    }

    default public Chain post(String path, Handler handler) {
        return this.all(Handlers.path(path, Handlers.chain(Handlers.post(), handler)));
    }

    default public Chain post(String path, Class<? extends Handler> handler) {
        return this.post(path, this.getRegistry().get(handler));
    }

    default public Chain post(Handler handler) {
        return this.post("", handler);
    }

    default public Chain post(Class<? extends Handler> handler) {
        return this.post(this.getRegistry().get(handler));
    }

    default public Chain prefix(String prefix, Action<? super Chain> action) throws Exception {
        return this.all(Handlers.prefix(prefix, this.chain(action)));
    }

    default public Chain prefix(String prefix, Class<? extends Action<? super Chain>> action) throws Exception {
        return this.prefix(prefix, this.getRegistry().get(action));
    }

    default public Chain put(String path, Handler handler) {
        return this.all(Handlers.path(path, Handlers.chain(Handlers.put(), handler)));
    }

    default public Chain put(String path, Class<? extends Handler> handler) {
        return this.put(path, this.getRegistry().get(handler));
    }

    default public Chain put(Handler handler) {
        return this.put("", handler);
    }

    default public Chain put(Class<? extends Handler> handler) {
        return this.put(this.getRegistry().get(handler));
    }

    default public Chain redirect(int code, String location) {
        return this.all(Handlers.redirect(code, location));
    }

    default public Chain register(Registry registry) {
        return this.all(Handlers.register(registry));
    }

    default public Chain register(Action<? super RegistrySpec> action) throws Exception {
        return this.register(Registry.of(action));
    }

    default public Chain register(Registry registry, Action<? super Chain> action) throws Exception {
        return this.all(Handlers.register(registry, this.chain(action)));
    }

    default public Chain register(Registry registry, Class<? extends Action<? super Chain>> action) throws Exception {
        return this.register(registry, this.getRegistry().get(action));
    }

    default public Chain register(Action<? super RegistrySpec> registryAction, Action<? super Chain> action) throws Exception {
        return this.register(Registry.of(registryAction), action);
    }

    default public Chain register(Action<? super RegistrySpec> registryAction, Class<? extends Action<? super Chain>> action) throws Exception {
        return this.register(registryAction, this.getRegistry().get(action));
    }

    default public Chain when(Predicate<? super Context> test, Action<? super Chain> action) throws Exception {
        return this.all(Handlers.when(test, this.chain(action)));
    }

    default public Chain when(Predicate<? super Context> test, Class<? extends Action<? super Chain>> action) throws Exception {
        return this.all(Handlers.when(test, this.chain(action)));
    }

    default public Chain when(boolean test, Action<? super Chain> action) throws Exception {
        if (test) {
            action.execute(this);
        }
        return this;
    }

    default public Chain when(boolean test, Class<? extends Action<? super Chain>> action) throws Exception {
        return this.when(test, this.getRegistry().get(action));
    }

    default public Chain onlyIf(Predicate<? super Context> test, Handler handler) {
        return this.all(Handlers.onlyIf(test, handler));
    }

    default public Chain onlyIf(Predicate<? super Context> test, Class<? extends Handler> handler) {
        return this.all(Handlers.onlyIf(test, this.getRegistry().get(handler)));
    }

    default public Chain notFound() {
        return this.all(Handlers.notFound());
    }
}

