/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ratpack.path.PathBinder;
import ratpack.path.PathBinding;
import ratpack.path.internal.DefaultPathBinding;

public class TokenPathBinder
implements PathBinder {
    private final ImmutableList<String> tokenNames;
    private final String target;
    private final Pattern regex;

    protected TokenPathBinder(ImmutableList<String> tokenNames, String target, Pattern regex) {
        this.tokenNames = tokenNames;
        this.target = target;
        this.regex = regex;
    }

    @Override
    public Optional<PathBinding> bind(PathBinding parentBinding) {
        Matcher matcher = this.regex.matcher(parentBinding.getPastBinding());
        if (matcher.matches()) {
            MatchResult matchResult = matcher.toMatchResult();
            String boundPath = matchResult.group(1);
            ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
            int i = 2;
            for (String name : this.tokenNames) {
                String value;
                if ((value = matchResult.group(i++)) == null) continue;
                paramsBuilder.put((Object)name, (Object)this.decodeURIComponent(value));
            }
            return Optional.of(new DefaultPathBinding(boundPath, (ImmutableMap<String, String>)paramsBuilder.build(), parentBinding, this.target));
        }
        return Optional.empty();
    }

    private String decodeURIComponent(String s) {
        return QueryStringDecoder.decodeComponent((String)s.replace("+", "%2B"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenPathBinder that = (TokenPathBinder)o;
        return this.regex.equals(that.regex) && this.tokenNames.equals(that.tokenNames);
    }

    public int hashCode() {
        int result = this.tokenNames.hashCode();
        result = 31 * result + this.regex.hashCode();
        return result;
    }
}

